/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.owasp.esapi.SecurityConfiguration;

public class DefaultSecurityConfiguration
implements SecurityConfiguration {
    private Properties properties = new Properties();
    private Map regexMap = null;
    public static final String RESOURCE_DIRECTORY = "org.owasp.esapi.resources";
    private static final String ALLOWED_LOGIN_ATTEMPTS = "AllowedLoginAttempts";
    private static final String APPLICATION_NAME = "ApplicationName";
    private static final String MASTER_PASSWORD = "MasterPassword";
    private static final String MASTER_SALT = "MasterSalt";
    private static final String VALID_EXTENSIONS = "ValidExtensions";
    private static final String MAX_UPLOAD_FILE_BYTES = "MaxUploadFileBytes";
    private static final String USERNAME_PARAMETER_NAME = "UsernameParameterName";
    private static final String PASSWORD_PARAMETER_NAME = "PasswordParameterName";
    private static final String MAX_OLD_PASSWORD_HASHES = "MaxOldPasswordHashes";
    private static final String ENCRYPTION_ALGORITHM = "EncryptionAlgorithm";
    private static final String HASH_ALGORITHM = "HashAlgorithm";
    private static final String CHARACTER_ENCODING = "CharacterEncoding";
    private static final String RANDOM_ALGORITHM = "RandomAlgorithm";
    private static final String DIGITAL_SIGNATURE_ALGORITHM = "DigitalSignatureAlgorithm";
    private static final String RESPONSE_CONTENT_TYPE = "ResponseContentType";
    private static final String REMEMBER_TOKEN_DURATION = "RememberTokenDuration";
    private static final String IDLE_TIMEOUT_DURATION = "IdleTimeoutDuration";
    private static final String ABSOLUTE_TIMEOUT_DURATION = "AbsoluteTimeoutDuration";
    private static final String LOG_LEVEL = "LogLevel";
    private static final String LOG_FILE_NAME = "LogFileName";
    private static final String MAX_LOG_FILE_SIZE = "MaxLogFileSize";
    private static final String LOG_ENCODING_REQUIRED = "LogEncodingRequired";
    protected final int MAX_REDIRECT_LOCATION = 1000;
    protected final int MAX_FILE_NAME_LENGTH = 1000;
    private static String resourceDirectory = System.getProperty("org.owasp.esapi.resources");
    private static long lastModified = 0L;
    public static final int DEFAULT_MAX_LOG_FILE_SIZE = 10000000;

    public DefaultSecurityConfiguration() {
        this.loadConfiguration();
    }

    public String getApplicationName() {
        return this.properties.getProperty(APPLICATION_NAME, "AppNameNotSpecified");
    }

    public char[] getMasterPassword() {
        return this.properties.getProperty(MASTER_PASSWORD).toCharArray();
    }

    public File getKeystore() {
        return new File(this.getResourceDirectory(), "keystore");
    }

    public String getResourceDirectory() {
        if (resourceDirectory != null && !resourceDirectory.endsWith(System.getProperty("file.separator"))) {
            resourceDirectory = resourceDirectory + System.getProperty("file.separator");
        }
        return resourceDirectory;
    }

    public void setResourceDirectory(String string) {
        resourceDirectory = string;
        if (resourceDirectory != null && !resourceDirectory.endsWith(System.getProperty("file.separator"))) {
            resourceDirectory = resourceDirectory + System.getProperty("file.separator");
        }
        this.loadConfiguration();
    }

    public byte[] getMasterSalt() {
        return this.properties.getProperty(MASTER_SALT).getBytes();
    }

    public List getAllowedFileExtensions() {
        String string = ".zip,.pdf,.tar,.gz,.xls,.properties,.txt,.xml";
        String[] stringArray = this.properties.getProperty(VALID_EXTENSIONS, string).split(",");
        return Arrays.asList(stringArray);
    }

    public int getAllowedFileUploadSize() {
        String string = this.properties.getProperty(MAX_UPLOAD_FILE_BYTES, "5000000");
        return Integer.parseInt(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationFromClasspath() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new IllegalArgumentException("Failure to load ESAPI configuration from classpath");
        }
        Properties properties = null;
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream("ESAPI.properties");
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            properties = null;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (properties == null) {
            throw new IllegalArgumentException("Can't load ESAPI.properties as a classloader resource");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        Object object2;
        File file = null;
        try {
            this.properties = this.loadConfigurationFromClasspath();
            this.logSpecial("Loaded ESAPI properties from classpath", null);
        }
        catch (Exception exception) {
            this.logSpecial("Can't load ESAPI properties from classpath, trying FileIO", exception);
            file = new File(this.getResourceDirectory(), "ESAPI.properties");
            if (file.lastModified() == lastModified) {
                return;
            }
            object2 = null;
            try {
                object2 = new FileInputStream(file);
                this.properties.load((InputStream)object2);
                this.logSpecial("Loaded ESAPI properties from " + file.getAbsolutePath(), null);
            }
            catch (Exception exception2) {
                this.logSpecial("Can't load ESAPI properties from " + file.getAbsolutePath(), exception2);
            }
            finally {
                try {
                    ((FileInputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
        this.logSpecial("  ========Master Configuration========", null);
        for (Object object2 : new TreeSet<Object>(this.properties.keySet())) {
            this.logSpecial("  |   " + (String)object2 + "=" + this.properties.get(object2), null);
        }
        if (file != null) {
            this.logSpecial("  ========Master Configuration========", null);
            lastModified = file.lastModified();
        }
        this.regexMap = new HashMap();
        object2 = this.getValidationPatternNames();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            Pattern pattern = this.getValidationPattern(string);
            if (string == null || pattern == null) continue;
            this.regexMap.put(string, pattern);
        }
    }

    private void logSpecial(String string, Throwable throwable) {
        System.out.println(string);
    }

    public String getPasswordParameterName() {
        return this.properties.getProperty(PASSWORD_PARAMETER_NAME, "password");
    }

    public String getUsernameParameterName() {
        return this.properties.getProperty(USERNAME_PARAMETER_NAME, "username");
    }

    public String getEncryptionAlgorithm() {
        return this.properties.getProperty(ENCRYPTION_ALGORITHM, "PBEWithMD5AndDES/CBC/PKCS5Padding");
    }

    public String getHashAlgorithm() {
        return this.properties.getProperty(HASH_ALGORITHM, "SHA-512");
    }

    public String getCharacterEncoding() {
        return this.properties.getProperty(CHARACTER_ENCODING, "UTF-8");
    }

    public String getDigitalSignatureAlgorithm() {
        return this.properties.getProperty(DIGITAL_SIGNATURE_ALGORITHM, "SHAwithDSA");
    }

    public String getRandomAlgorithm() {
        return this.properties.getProperty(RANDOM_ALGORITHM, "SHA1PRNG");
    }

    public int getAllowedLoginAttempts() {
        String string = this.properties.getProperty(ALLOWED_LOGIN_ATTEMPTS, "5");
        return Integer.parseInt(string);
    }

    public int getMaxOldPasswordHashes() {
        String string = this.properties.getProperty(MAX_OLD_PASSWORD_HASHES, "12");
        return Integer.parseInt(string);
    }

    public SecurityConfiguration.Threshold getQuota(String string) {
        Object object;
        int n = 0;
        String string2 = this.properties.getProperty(string + ".count");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        int n2 = 0;
        String string3 = this.properties.getProperty(string + ".interval");
        if (string3 != null) {
            n2 = Integer.parseInt(string3);
        }
        List<Object> list = new ArrayList();
        String string4 = this.properties.getProperty(string + ".actions");
        if (string4 != null) {
            object = string4.split(",");
            list = Arrays.asList(object);
        }
        object = new SecurityConfiguration.Threshold(string, n, n2, list);
        return object;
    }

    public int getLogLevel() {
        String string = this.properties.getProperty(LOG_LEVEL);
        if (string == null) {
            this.logSpecial("The LOG-LEVEL property in the ESAPI properties file is not defined.", null);
            return 600;
        }
        if (string.equalsIgnoreCase("OFF")) {
            return Integer.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("FATAL")) {
            return 1000;
        }
        if (string.equalsIgnoreCase("ERROR")) {
            return 800;
        }
        if (string.equalsIgnoreCase("WARNING")) {
            return 600;
        }
        if (string.equalsIgnoreCase("INFO")) {
            return 400;
        }
        if (string.equalsIgnoreCase("DEBUG")) {
            return 200;
        }
        if (string.equalsIgnoreCase("TRACE")) {
            return 100;
        }
        if (string.equalsIgnoreCase("ALL")) {
            return Integer.MIN_VALUE;
        }
        this.logSpecial("The LOG-LEVEL property in the ESAPI properties file has the unrecognized value: " + string, null);
        return 600;
    }

    public String getLogFileName() {
        return this.properties.getProperty(LOG_FILE_NAME, "ESAPI_logging_file");
    }

    public int getMaxLogFileSize() {
        String string = this.properties.getProperty(MAX_LOG_FILE_SIZE);
        if (string == null) {
            return 10000000;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 10000000;
        }
    }

    public boolean getLogEncodingRequired() {
        String string = this.properties.getProperty(LOG_ENCODING_REQUIRED);
        return string != null && string.equalsIgnoreCase("true");
    }

    public String getResponseContentType() {
        return this.properties.getProperty(RESPONSE_CONTENT_TYPE, "text/html; charset=UTF-8");
    }

    public long getRememberTokenDuration() {
        String string = this.properties.getProperty(REMEMBER_TOKEN_DURATION, "14");
        long l = Long.parseLong(string);
        long l2 = 86400000L * l;
        return l2;
    }

    public int getSessionIdleTimeoutLength() {
        String string = this.properties.getProperty(IDLE_TIMEOUT_DURATION, "20");
        int n = Integer.parseInt(string);
        int n2 = 60000 * n;
        return n2;
    }

    public int getSessionAbsoluteTimeoutLength() {
        String string = this.properties.getProperty(ABSOLUTE_TIMEOUT_DURATION, "120");
        int n = Integer.parseInt(string);
        int n2 = 60000 * n;
        return n2;
    }

    public Iterator getValidationPatternNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.properties.keySet()) {
            if (!string.startsWith("Validator.")) continue;
            treeSet.add(string.substring(string.indexOf(46) + 1));
        }
        return treeSet.iterator();
    }

    public Pattern getValidationPattern(String string) {
        String string2 = this.properties.getProperty("Validator." + string);
        if (string2 == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(string2);
        return pattern;
    }
}

