/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.DefaultEncoder;

public class DefaultRandomizer
implements Randomizer {
    private SecureRandom secureRandom = null;
    private final Logger logger = ESAPI.getLogger("Randomizer");

    public DefaultRandomizer() {
        String string = ESAPI.securityConfiguration().getRandomAlgorithm();
        try {
            this.secureRandom = SecureRandom.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            new EncryptionException("Error creating randomizer", "Can't find random algorithm " + string, noSuchAlgorithmException);
        }
    }

    public String getRandomString(int n, char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = this.secureRandom.nextInt(cArray.length);
            stringBuffer.append(cArray[n2]);
        }
        String string = stringBuffer.toString();
        return string;
    }

    public boolean getRandomBoolean() {
        return this.secureRandom.nextBoolean();
    }

    public int getRandomInteger(int n, int n2) {
        return this.secureRandom.nextInt(n2 - n) + n;
    }

    public long getRandomLong() {
        return this.secureRandom.nextLong();
    }

    public float getRandomReal(float f, float f2) {
        float f3 = f2 - f;
        return this.secureRandom.nextFloat() * f3 + f;
    }

    public String getRandomFilename(String string) {
        return this.getRandomString(12, DefaultEncoder.CHAR_ALPHANUMERICS) + "." + string;
    }

    public String getRandomGUID() throws EncryptionException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(InetAddress.getLocalHost().toString());
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append("0.0.0.0");
        }
        stringBuffer.append(":");
        stringBuffer.append(Long.toString(System.currentTimeMillis()));
        stringBuffer.append(":");
        stringBuffer.append(this.getRandomString(20, DefaultEncoder.CHAR_ALPHANUMERICS));
        String string = ESAPI.encryptor().hash(stringBuffer.toString(), "salt");
        byte[] byArray = null;
        try {
            byArray = ESAPI.encoder().decodeFromBase64(string);
        }
        catch (IOException iOException) {
            throw new EncryptionException("GUID creation error", "Problem decoding hash while creating GUID: " + string);
        }
        if (byArray == null || byArray.length == 0) {
            throw new EncryptionException("GUID creation error", "Entropy array was null or zero length");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer2.append('0');
            }
            stringBuffer2.append(Integer.toHexString(n));
        }
        String string2 = stringBuffer2.toString().toUpperCase();
        if (string2.length() < 20) {
            throw new EncryptionException("GUID creation error", "Entropy string too short");
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(string2.substring(0, 8));
        stringBuffer3.append("-");
        stringBuffer3.append(string2.substring(8, 12));
        stringBuffer3.append("-");
        stringBuffer3.append(string2.substring(12, 16));
        stringBuffer3.append("-");
        stringBuffer3.append(string2.substring(16, 20));
        stringBuffer3.append("-");
        stringBuffer3.append(string2.substring(20));
        return stringBuffer3.toString();
    }
}

