/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.IntrusionDetector;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.EnterpriseSecurityException;
import org.owasp.esapi.errors.IntrusionException;

public class DefaultIntrusionDetector
implements IntrusionDetector {
    private final Logger logger = ESAPI.getLogger("IntrusionDetector");
    private Map userEvents = new WeakHashMap();

    public void addException(Exception exception) {
        if (exception instanceof EnterpriseSecurityException) {
            this.logger.warning(Logger.SECURITY, false, ((EnterpriseSecurityException)exception).getLogMessage(), exception);
        } else {
            this.logger.warning(Logger.SECURITY, false, exception.getMessage(), exception);
        }
        User user = ESAPI.authenticator().getCurrentUser();
        String string = exception.getClass().getName();
        if (exception instanceof IntrusionException) {
            return;
        }
        try {
            this.addSecurityEvent(user, string);
        }
        catch (IntrusionException intrusionException) {
            SecurityConfiguration.Threshold threshold = ESAPI.securityConfiguration().getQuota(string);
            for (String string2 : threshold.actions) {
                String string3 = "User exceeded quota of " + threshold.count + " per " + threshold.interval + " seconds for event " + string + ". Taking actions " + threshold.actions;
                this.takeSecurityAction(string2, string3);
            }
        }
    }

    public void addEvent(String string, String string2) throws IntrusionException {
        this.logger.warning(Logger.SECURITY, false, "Security event " + string + " received : " + string2);
        User user = ESAPI.authenticator().getCurrentUser();
        try {
            this.addSecurityEvent(user, "event." + string);
        }
        catch (IntrusionException intrusionException) {
            SecurityConfiguration.Threshold threshold = ESAPI.securityConfiguration().getQuota("event." + string);
            for (String string3 : threshold.actions) {
                String string4 = "User exceeded quota of " + threshold.count + " per " + threshold.interval + " seconds for event " + string + ". Taking actions " + threshold.actions;
                this.takeSecurityAction(string3, string4);
            }
        }
    }

    private void takeSecurityAction(String string, String string2) {
        User user;
        if (string.equals("log")) {
            this.logger.fatal(Logger.SECURITY, false, "INTRUSION - " + string2);
        }
        if ((user = ESAPI.authenticator().getCurrentUser()) == User.ANONYMOUS) {
            return;
        }
        if (string.equals("disable")) {
            user.disable();
        }
        if (string.equals("logout")) {
            user.logout();
        }
    }

    private void addSecurityEvent(User user, String string) {
        Event event;
        HashMap<String, Event> hashMap = (HashMap<String, Event>)this.userEvents.get(user.getAccountName());
        if (hashMap == null) {
            hashMap = new HashMap<String, Event>();
            this.userEvents.put(user.getAccountName(), hashMap);
        }
        if ((event = (Event)hashMap.get(string)) == null) {
            event = new Event(string);
            hashMap.put(string, event);
        }
        SecurityConfiguration.Threshold threshold = ESAPI.securityConfiguration().getQuota(string);
        if (threshold.count > 0) {
            event.increment(threshold.count, threshold.interval);
        }
    }

    private static class Event {
        public String key;
        public Stack times = new Stack();
        public long count = 0L;

        public Event(String string) {
            this.key = string;
        }

        public void increment(int n, long l) throws IntrusionException {
            Date date = new Date();
            this.times.add(0, date);
            while (this.times.size() > n) {
                this.times.remove(this.times.size() - 1);
            }
            if (this.times.size() == n) {
                Date date2 = (Date)this.times.get(n - 1);
                long l2 = date2.getTime();
                long l3 = date.getTime();
                if (l3 - l2 < l * 1000L) {
                    throw new IntrusionException("Threshold exceeded", "Exceeded threshold for " + this.key);
                }
            }
        }
    }
}

