/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.errors.ValidationUploadException;
import org.owasp.esapi.filters.SafeRequest;
import org.owasp.esapi.filters.SafeResponse;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;

public class DefaultHTTPUtilities
implements HTTPUtilities {
    private final Logger logger = ESAPI.getLogger("HTTPUtilities");
    int maxBytes = ESAPI.securityConfiguration().getAllowedFileUploadSize();
    private ThreadLocalRequest currentRequest = new ThreadLocalRequest();
    private ThreadLocalResponse currentResponse = new ThreadLocalResponse();

    public String addCSRFToken(String string) {
        User user = ESAPI.authenticator().getCurrentUser();
        if (user.isAnonymous()) {
            return string;
        }
        if (string.indexOf(63) != -1 || string.indexOf(38) != -1) {
            return string + "&" + user.getCSRFToken();
        }
        return string + "?" + user.getCSRFToken();
    }

    public Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public String getCSRFToken() {
        User user = ESAPI.authenticator().getCurrentUser();
        if (user == null) {
            return null;
        }
        return user.getCSRFToken();
    }

    public String setRememberToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, int n, String string2, String string3) {
        User user = ESAPI.authenticator().getCurrentUser();
        try {
            this.killCookie(httpServletRequest, httpServletResponse, "ESAPIRememberToken");
            String string4 = ESAPI.randomizer().getRandomString(8, DefaultEncoder.CHAR_ALPHANUMERICS);
            String string5 = string4 + ":" + user.getAccountName() + ":" + string;
            long l = ESAPI.encryptor().getRelativeTimeStamp(n * 1000);
            String string6 = ESAPI.encryptor().seal(string5, l);
            Cookie cookie = new Cookie("ESAPIRememberToken", string6);
            cookie.setMaxAge(n);
            cookie.setDomain(string2);
            cookie.setPath(string3);
            httpServletResponse.addCookie(cookie);
            this.logger.info(Logger.SECURITY, true, "Enabled remember me token for " + user.getAccountName());
            return string6;
        }
        catch (IntegrityException integrityException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set remember me token failed for " + user.getAccountName(), integrityException);
            return null;
        }
    }

    public void assertSecureRequest(HttpServletRequest httpServletRequest) throws AccessControlException {
        String string;
        if (!this.isSecureChannel(httpServletRequest)) {
            throw new AccessControlException("Insecure request received", "Received non-SSL request");
        }
        String string2 = httpServletRequest.getMethod();
        if (!string2.equals(string = "POST")) {
            throw new AccessControlException("Insecure request received", "Received request using " + string2 + " when only " + string + " is allowed");
        }
    }

    public HttpSession changeSessionIdentifier(HttpServletRequest httpServletRequest) throws AuthenticationException {
        Object object;
        Object object2;
        HttpSession httpSession = httpServletRequest.getSession();
        HashMap<HttpSession, Object> hashMap = new HashMap<HttpSession, Object>();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = httpSession.getAttribute((String)object2);
            hashMap.put((HttpSession)object2, object);
        }
        httpSession.invalidate();
        object2 = httpServletRequest.getSession();
        object = ESAPI.authenticator().getCurrentUser();
        object.addSession((HttpSession)object2);
        object.removeSession(httpSession);
        for (Map.Entry entry : hashMap.entrySet()) {
            object2.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return object2;
    }

    public void verifyCSRFToken(HttpServletRequest httpServletRequest) throws IntrusionException {
        User user = ESAPI.authenticator().getCurrentUser();
        if (httpServletRequest.getAttribute(user.getCSRFToken()) != null) {
            return;
        }
        if (httpServletRequest.getParameter(user.getCSRFToken()) == null) {
            throw new IntrusionException("Authentication failed", "Possibly forged HTTP request without proper CSRF token detected");
        }
    }

    public String decryptHiddenField(String string) {
        try {
            return ESAPI.encryptor().decrypt(string);
        }
        catch (EncryptionException encryptionException) {
            throw new IntrusionException("Invalid request", "Tampering detected. Hidden field data did not decrypt properly.", encryptionException);
        }
    }

    public Map decryptQueryString(String string) throws EncryptionException {
        String string2 = ESAPI.encryptor().decrypt(string);
        return this.queryToMap(string2);
    }

    public Map decryptStateFromCookie(HttpServletRequest httpServletRequest) throws EncryptionException {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        Cookie cookie = null;
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals("state")) continue;
            cookie = cookieArray[i];
        }
        String string = cookie.getValue();
        String string2 = ESAPI.encryptor().decrypt(string);
        return this.queryToMap(string2);
    }

    public String encryptHiddenField(String string) throws EncryptionException {
        return ESAPI.encryptor().encrypt(string);
    }

    public String encryptQueryString(String string) throws EncryptionException {
        return ESAPI.encryptor().encrypt(string);
    }

    public void encryptStateInCookie(HttpServletResponse httpServletResponse, Map map) throws EncryptionException {
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                object = iterator.next();
                string = ESAPI.encoder().encodeForURL(object.getKey().toString());
                String string2 = ESAPI.encoder().encodeForURL(object.getValue().toString());
                stringBuffer.append(string + "=" + string2);
                if (!iterator.hasNext()) continue;
                stringBuffer.append("&");
            }
            catch (EncodingException encodingException) {
                this.logger.error(Logger.SECURITY, false, "Problem encrypting state in cookie - skipping entry", encodingException);
            }
        }
        object = ESAPI.encryptor().encrypt(stringBuffer.toString());
        string = new Cookie("state", (String)object);
        httpServletResponse.addCookie((Cookie)string);
    }

    public List getSafeFileUploads(HttpServletRequest httpServletRequest, File file, File file2) throws ValidationException {
        if (!file.exists() && !file.mkdirs()) {
            throw new ValidationUploadException("Upload failed", "Could not create temp directory: " + file.getAbsolutePath());
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new ValidationUploadException("Upload failed", "Could not create final upload directory: " + file2.getAbsolutePath());
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            final HttpSession httpSession = httpServletRequest.getSession(false);
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                throw new ValidationUploadException("Upload failed", "Not a multipart request");
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory(0, file);
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            servletFileUpload.setSizeMax((long)this.maxBytes);
            ProgressListener progressListener = new ProgressListener(){
                private long megaBytes = -1L;
                private long progress = 0L;

                public void update(long l, long l2, int n) {
                    if (n == 0) {
                        return;
                    }
                    long l3 = l / 1000000L;
                    if (this.megaBytes == l3) {
                        return;
                    }
                    this.megaBytes = l3;
                    this.progress = (long)((double)l / (double)l2 * 100.0);
                    if (httpSession != null) {
                        httpSession.setAttribute("progress", (Object)Long.toString(this.progress));
                    }
                }
            };
            servletFileUpload.setProgressListener(progressListener);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            for (FileItem fileItem : list) {
                if (fileItem.isFormField() || fileItem.getName() == null || fileItem.getName().equals("")) continue;
                String[] stringArray = fileItem.getName().split("[\\/\\\\]");
                String string = stringArray[stringArray.length - 1];
                if (!ESAPI.validator().isValidFileName("upload", string, false)) {
                    throw new ValidationUploadException("Upload only simple filenames with the following extensions " + ESAPI.securityConfiguration().getAllowedFileExtensions(), "Upload failed isValidFileName check");
                }
                this.logger.info(Logger.SECURITY, true, "File upload requested: " + string);
                File file3 = new File(file2, string);
                if (file3.exists()) {
                    String[] stringArray2 = string.split("\\/.");
                    String string2 = "";
                    if (stringArray2.length > 1) {
                        string2 = stringArray2[stringArray2.length - 1];
                    }
                    String string3 = string.substring(0, string.length() - string2.length());
                    file3 = File.createTempFile(string3, "." + string2, file2);
                }
                fileItem.write(file3);
                arrayList.add(file3);
                fileItem.delete();
                this.logger.fatal(Logger.SECURITY, true, "File successfully uploaded: " + file3);
                if (httpSession == null) continue;
                httpSession.setAttribute("progress", (Object)Long.toString(0L));
            }
        }
        catch (Exception exception) {
            if (exception instanceof ValidationUploadException) {
                throw (ValidationException)exception;
            }
            throw new ValidationUploadException("Upload failure", "Problem during upload:" + exception.getMessage(), exception);
        }
        return arrayList;
    }

    public boolean isSecureChannel(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getRequestURL() == null || httpServletRequest.getRequestURL().toString().length() == 0) {
            return false;
        }
        return httpServletRequest.getRequestURL().charAt(4) == 's';
    }

    public void killAllCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                this.killCookie(httpServletRequest, httpServletResponse, cookie.getName());
            }
        }
    }

    public void killCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = "//";
        String string3 = "";
        Cookie cookie = ESAPI.httpUtilities().getCookie(httpServletRequest, string);
        if (cookie != null) {
            string2 = cookie.getPath();
            string3 = cookie.getDomain();
        }
        Cookie cookie2 = new Cookie(string, "deleted");
        cookie2.setMaxAge(0);
        if (string3 != null) {
            cookie2.setDomain(string3);
        }
        if (string2 != null) {
            cookie2.setPath(string2);
        }
        httpServletResponse.addCookie(cookie2);
    }

    private Map queryToMap(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String[] stringArray2 = stringArray[i].split("=");
                String string2 = ESAPI.encoder().decodeFromURL(stringArray2[0]);
                String string3 = ESAPI.encoder().decodeFromURL(stringArray2[1]);
                treeMap.put(string2, string3);
                continue;
            }
            catch (EncodingException encodingException) {
                // empty catch block
            }
        }
        return treeMap;
    }

    public void safeSendForward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws AccessControlException, ServletException, IOException {
        if (!string2.startsWith("WEB-INF")) {
            throw new AccessControlException("Forward failed", "Bad forward location: " + string2);
        }
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string2);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void setSafeContentType(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType(((DefaultSecurityConfiguration)ESAPI.securityConfiguration()).getResponseContentType());
    }

    public void setNoCacheHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", -1L);
    }

    public SafeRequest getCurrentRequest() {
        SafeRequest safeRequest = (SafeRequest)this.currentRequest.get();
        if (safeRequest == null) {
            throw new NullPointerException("Cannot use current request until it is set with HTTPUtilities.setCurrentHTTP()");
        }
        return safeRequest;
    }

    public SafeResponse getCurrentResponse() {
        SafeResponse safeResponse = (SafeResponse)this.currentResponse.get();
        if (safeResponse == null) {
            throw new NullPointerException("Cannot use current response until it is set with HTTPUtilities.setCurrentHTTP()");
        }
        return safeResponse;
    }

    public void setCurrentHTTP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SafeRequest safeRequest = null;
        SafeResponse safeResponse = null;
        safeRequest = httpServletRequest instanceof SafeRequest ? (SafeRequest)httpServletRequest : new SafeRequest(httpServletRequest);
        safeResponse = httpServletResponse instanceof SafeResponse ? (SafeResponse)httpServletResponse : new SafeResponse(httpServletResponse);
        this.currentRequest.set(safeRequest);
        this.currentResponse.set(safeResponse);
    }

    public void logHTTPRequest(HttpServletRequest httpServletRequest, Logger logger) {
        this.logHTTPRequest(httpServletRequest, logger, null);
    }

    public void logHTTPRequest(HttpServletRequest httpServletRequest, Logger logger, List list) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = httpServletRequest.getParameterMap().keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String[] stringArray = (String[])httpServletRequest.getParameterMap().get(object);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append((String)object + "=");
                if (list != null && list.contains(object)) {
                    stringBuffer.append("********");
                } else {
                    stringBuffer.append(stringArray[i]);
                }
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("&");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append("&");
        }
        object = httpServletRequest.getCookies();
        if (object != null) {
            for (int i = 0; i < ((Cookie[])object).length; ++i) {
                if (object[i].getName().equals("JSESSIONID")) continue;
                stringBuffer.append("+" + object[i].getName() + "=" + object[i].getValue());
            }
        }
        String string = httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURL() + (stringBuffer.length() > 0 ? "?" + stringBuffer : "");
        logger.info(Logger.SECURITY, true, string);
    }

    private class ThreadLocalResponse
    extends InheritableThreadLocal {
        private ThreadLocalResponse() {
        }

        public Object initialValue() {
            return null;
        }

        public SafeResponse getResponse() {
            return (SafeResponse)super.get();
        }

        public void setResponse(SafeResponse safeResponse) {
            super.set(safeResponse);
        }
    }

    private class ThreadLocalRequest
    extends InheritableThreadLocal {
        private ThreadLocalRequest() {
        }

        public Object initialValue() {
            return null;
        }

        public SafeRequest getRequest() {
            return (SafeRequest)super.get();
        }

        public void setRequest(SafeRequest safeRequest) {
            super.set(safeRequest);
        }
    }
}

