/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Executor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.errors.ExecutorException;

public class DefaultExecutor
implements Executor {
    private final Logger logger = ESAPI.getLogger("Executor");

    public String executeSystemCommand(File file, List list, File file2, Codec codec) throws ExecutorException {
        try {
            Object object;
            this.logger.warning(Logger.SECURITY, true, "Initiating executable: " + file + " " + list + " in " + file2);
            if (!file.getCanonicalPath().equalsIgnoreCase(file.getPath())) {
                throw new ExecutorException("Execution failure", "Invalid path to executable file: " + file);
            }
            if (!file.exists()) {
                throw new ExecutorException("Execution failure", "No such executable: " + file);
            }
            for (int i = 0; i < list.size(); ++i) {
                object = (String)list.get(i);
                list.set(i, ESAPI.encoder().encodeForOS(codec, (String)object));
            }
            if (!file2.exists()) {
                throw new ExecutorException("Execution failure", "No such working directory for running executable: " + file2.getPath());
            }
            list.add(0, file.getCanonicalPath());
            String[] stringArray = list.toArray(new String[0]);
            object = Runtime.getRuntime().exec(stringArray, new String[0], file2);
            String string = this.readStream(((Process)object).getInputStream());
            String string2 = this.readStream(((Process)object).getErrorStream());
            if (string2 != null && string2.length() > 0) {
                this.logger.warning(Logger.SECURITY, false, "Error during system command: " + string2);
            }
            this.logger.warning(Logger.SECURITY, true, "System command complete: " + list);
            return string;
        }
        catch (Exception exception) {
            throw new ExecutorException("Execution failure", "Exception thrown during execution of system command: " + exception.getMessage(), exception);
        }
    }

    private String readStream(InputStream inputStream) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }
}

