/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncryptedProperties;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.EncryptionException;

public class DefaultEncryptedProperties
implements EncryptedProperties {
    private final Properties properties = new Properties();
    private final Logger logger = ESAPI.getLogger("EncryptedProperties");

    public synchronized String getProperty(String string) throws EncryptionException {
        try {
            return ESAPI.encryptor().decrypt(this.properties.getProperty(string));
        }
        catch (Exception exception) {
            throw new EncryptionException("Property retrieval failure", "Couldn't decrypt property", exception);
        }
    }

    public synchronized String setProperty(String string, String string2) throws EncryptionException {
        try {
            return (String)this.properties.setProperty(string, ESAPI.encryptor().encrypt(string2));
        }
        catch (Exception exception) {
            throw new EncryptionException("Property setting failure", "Couldn't encrypt property", exception);
        }
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        this.logger.trace(Logger.SECURITY, true, "Encrypted properties loaded successfully");
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        String string;
        File file = new File(stringArray[0]);
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY, true, "Loading encrypted properties from " + file.getAbsolutePath());
        if (!file.exists()) {
            throw new IOException("Properties file not found: " + file.getAbsolutePath());
        }
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY, true, "Encrypted properties found in " + file.getAbsolutePath());
        DefaultEncryptedProperties defaultEncryptedProperties = new DefaultEncryptedProperties();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file);
            defaultEncryptedProperties.load(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = null;
            do {
                System.out.print("Enter key: ");
                string2 = bufferedReader.readLine();
                System.out.print("Enter value: ");
                string = bufferedReader.readLine();
                if (string2 == null || string2.length() <= 0 || string == null || string.length() <= 0) continue;
                defaultEncryptedProperties.setProperty(string2, string);
            } while (string2 != null && string2.length() > 0);
            defaultEncryptedProperties.store(fileOutputStream, "Encrypted Properties File");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        for (String string2 : defaultEncryptedProperties.keySet()) {
            string = defaultEncryptedProperties.getProperty(string2);
            System.out.println("   " + string2 + "=" + string);
        }
    }
}

