/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Base64;
import org.owasp.esapi.codecs.CSSCodec;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.HTMLEntityCodec;
import org.owasp.esapi.codecs.JavaScriptCodec;
import org.owasp.esapi.codecs.PercentCodec;
import org.owasp.esapi.codecs.PushbackString;
import org.owasp.esapi.codecs.VBScriptCodec;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;
import sun.text.Normalizer;

public class DefaultEncoder
implements Encoder {
    List codecs = new ArrayList();
    private HTMLEntityCodec htmlCodec = new HTMLEntityCodec();
    private PercentCodec percentCodec = new PercentCodec();
    private JavaScriptCodec javaScriptCodec = new JavaScriptCodec();
    private VBScriptCodec vbScriptCodec = new VBScriptCodec();
    private CSSCodec cssCodec = new CSSCodec();
    private final Logger logger = ESAPI.getLogger("Encoder");
    private static final char[] IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
    private static final char[] IMMUNE_CSS = new char[]{' '};
    private static final char[] IMMUNE_JAVASCRIPT = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_VBSCRIPT = new char[]{' '};
    private static final char[] IMMUNE_XML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_SQL = new char[]{' '};
    private static final char[] IMMUNE_OS = new char[]{'-'};
    private static final char[] IMMUNE_XMLATTR = new char[]{',', '.', '-', '_'};
    private static final char[] IMMUNE_XPATH = new char[]{',', '.', '-', '_', ' '};

    public DefaultEncoder() {
        this.codecs.add(this.htmlCodec);
        this.codecs.add(this.percentCodec);
        this.codecs.add(this.javaScriptCodec);
    }

    public DefaultEncoder(List list) {
        for (Object e : list) {
            if (e instanceof Codec) continue;
            throw new IllegalArgumentException("Codec list must contain only Codec instances");
        }
        this.codecs = list;
    }

    public String canonicalize(String string) {
        if (string == null) {
            return null;
        }
        return this.canonicalize(string, true);
    }

    public String canonicalize(String string, boolean bl) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = this.canonicalizeOnce(string);
        if (!string3.equals(string2 = this.canonicalizeOnce(string3))) {
            if (bl) {
                throw new IntrusionException("Input validation failure", "Double encoding detected in " + string);
            }
            this.logger.warning(Logger.SECURITY, false, "Double encoding detected in " + string);
        }
        return string3;
    }

    private String canonicalizeOnce(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        PushbackString pushbackString = new PushbackString(string);
        while (pushbackString.hasNext()) {
            boolean bl = this.decodeNext(pushbackString);
            Character c = pushbackString.next();
            if (bl) {
                pushbackString.pushback(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean decodeNext(PushbackString pushbackString) {
        Iterator iterator = this.codecs.iterator();
        pushbackString.mark();
        while (iterator.hasNext()) {
            pushbackString.reset();
            Codec codec = (Codec)iterator.next();
            Character c = codec.decodeCharacter(pushbackString);
            if (c == null) continue;
            pushbackString.pushback(c);
            return true;
        }
        pushbackString.reset();
        return false;
    }

    public String normalize(String string) {
        String string2 = Normalizer.normalize((String)string, (Normalizer.Mode)Normalizer.DECOMP, (int)0);
        return string2.replaceAll("[^\\p{ASCII}]", "");
    }

    private String encode(char c, Codec codec, char[] cArray, char[] cArray2) {
        if (this.isContained(cArray, c) || this.isContained(cArray2, c)) {
            return "" + c;
        }
        return codec.encodeCharacter(new Character(c));
    }

    public String encodeForHTML(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r') {
                stringBuffer.append(c);
                continue;
            }
            if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                this.logger.warning(Logger.SECURITY, false, "Attempt to HTML entity encode illegal character: " + c + " (skipping)");
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(this.encode(c, this.htmlCodec, CHAR_ALPHANUMERICS, IMMUNE_HTML));
        }
        return stringBuffer.toString();
    }

    public String encodeForHTMLAttribute(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.htmlCodec, CHAR_ALPHANUMERICS, IMMUNE_HTMLATTR));
        }
        return stringBuffer.toString();
    }

    public String encodeForCSS(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') continue;
            stringBuffer.append(this.encode(c, this.cssCodec, CHAR_ALPHANUMERICS, IMMUNE_CSS));
        }
        return stringBuffer.toString();
    }

    public String encodeForJavaScript(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.javaScriptCodec, CHAR_ALPHANUMERICS, IMMUNE_JAVASCRIPT));
        }
        return stringBuffer.toString();
    }

    public String encodeForVBScript(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.vbScriptCodec, CHAR_ALPHANUMERICS, IMMUNE_VBSCRIPT));
        }
        return stringBuffer.toString();
    }

    public String encodeForSQL(Codec codec, String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, codec, CHAR_ALPHANUMERICS, IMMUNE_SQL));
        }
        return stringBuffer.toString();
    }

    public String encodeForOS(Codec codec, String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, codec, CHAR_ALPHANUMERICS, IMMUNE_OS));
        }
        return stringBuffer.toString();
    }

    public String encodeForLDAP(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block7;
                }
                case '*': {
                    stringBuffer.append("\\2a");
                    continue block7;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    continue block7;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String encodeForDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0 && (string.charAt(0) == ' ' || string.charAt(0) == '#')) {
            stringBuffer.append('\\');
        }
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case ',': {
                    stringBuffer.append("\\,");
                    continue block9;
                }
                case '+': {
                    stringBuffer.append("\\+");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("\\<");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("\\>");
                    continue block9;
                }
                case ';': {
                    stringBuffer.append("\\;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (string.length() > 1 && string.charAt(string.length() - 1) == ' ') {
            stringBuffer.insert(stringBuffer.length() - 1, '\\');
        }
        return stringBuffer.toString();
    }

    public String encodeForXPath(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.htmlCodec, CHAR_ALPHANUMERICS, IMMUNE_XPATH));
        }
        return stringBuffer.toString();
    }

    public String encodeForXML(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.htmlCodec, CHAR_ALPHANUMERICS, IMMUNE_XML));
        }
        return stringBuffer.toString();
    }

    public String encodeForXMLAttribute(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encode(c, this.htmlCodec, CHAR_ALPHANUMERICS, IMMUNE_XMLATTR));
        }
        return stringBuffer.toString();
    }

    public String encodeForURL(String string) throws EncodingException {
        try {
            return URLEncoder.encode(string, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncodingException("Encoding failure", "Encoding not supported", unsupportedEncodingException);
        }
        catch (Exception exception) {
            throw new EncodingException("Encoding failure", "Problem URL decoding input", exception);
        }
    }

    public String decodeFromURL(String string) throws EncodingException {
        String string2 = this.canonicalize(string);
        try {
            return URLDecoder.decode(string2, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncodingException("Decoding failed", "Encoding not supported", unsupportedEncodingException);
        }
        catch (Exception exception) {
            throw new EncodingException("Decoding failed", "Problem URL decoding input", exception);
        }
    }

    public String encodeForBase64(byte[] byArray, boolean bl) {
        int n = 0;
        if (!bl) {
            n |= 8;
        }
        return Base64.encodeBytes(byArray, n);
    }

    public byte[] decodeFromBase64(String string) throws IOException {
        return Base64.decode(string);
    }

    protected boolean isContained(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    static {
        Arrays.sort(IMMUNE_HTML);
        Arrays.sort(IMMUNE_HTMLATTR);
        Arrays.sort(IMMUNE_JAVASCRIPT);
        Arrays.sort(IMMUNE_VBSCRIPT);
        Arrays.sort(IMMUNE_XML);
        Arrays.sort(IMMUNE_XMLATTR);
        Arrays.sort(IMMUNE_XPATH);
        Arrays.sort(CHAR_LOWERS);
        Arrays.sort(CHAR_UPPERS);
        Arrays.sort(CHAR_DIGITS);
        Arrays.sort(CHAR_SPECIALS);
        Arrays.sort(CHAR_LETTERS);
        Arrays.sort(CHAR_ALPHANUMERICS);
        Arrays.sort(CHAR_PASSWORD_LOWERS);
        Arrays.sort(CHAR_PASSWORD_UPPERS);
        Arrays.sort(CHAR_PASSWORD_DIGITS);
        Arrays.sort(CHAR_PASSWORD_SPECIALS);
        Arrays.sort(CHAR_PASSWORD_LETTERS);
    }
}

