/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;

public class SafeResponse
implements HttpServletResponse {
    private HttpServletResponse response;
    private final Logger logger = ESAPI.getLogger("SafeResponse");

    public SafeResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    public void addCookie(Cookie cookie) {
        String string = cookie.getName();
        String string2 = cookie.getValue();
        int n = cookie.getMaxAge();
        String string3 = cookie.getDomain();
        String string4 = cookie.getPath();
        this.addCookie(string, string2, n, string3, string4);
    }

    public void addCookie(String string, String string2, int n, String string3, String string4) {
        try {
            String string5 = ESAPI.validator().getValidInput("safeAddCookie", string, "HTTPCookieName", 50, false);
            String string6 = ESAPI.validator().getValidInput("safeAddCookie", string2, "HTTPCookieValue", 5000, false);
            String string7 = string5 + "=" + string6;
            if (n != -1) {
                string7 = string7 + "; Max-Age=" + n;
            }
            if (string3 != null) {
                string7 = string7 + "; Domain=" + string3;
            }
            if (string4 != null) {
                string7 = string7 + "; Path=" + string4;
            }
            string7 = string7 + "; Secure; HttpOnly";
            this.response.addHeader("Set-Cookie", string7);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid cookie denied", validationException);
        }
    }

    public void addDateHeader(String string, long l) {
        try {
            String string2 = ESAPI.validator().getValidInput("safeSetDateHeader", string, "HTTPHeaderName", 20, false);
            this.response.addDateHeader(string2, l);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid date header name denied", validationException);
        }
    }

    public void addHeader(String string, String string2) {
        try {
            String string3 = StringUtilities.stripControls(string);
            String string4 = StringUtilities.stripControls(string2);
            String string5 = ESAPI.validator().getValidInput("addHeader", string3, "HTTPHeaderName", 20, false);
            String string6 = ESAPI.validator().getValidInput("addHeader", string4, "HTTPHeaderValue", 500, false);
            this.response.setHeader(string5, string6);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to add invalid header denied", validationException);
        }
    }

    public void addIntHeader(String string, int n) {
        try {
            String string2 = ESAPI.validator().getValidInput("safeSetDateHeader", string, "HTTPHeaderName", 20, false);
            this.response.addIntHeader(string2, n);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid int header name denied", validationException);
        }
    }

    public boolean containsHeader(String string) {
        return this.response.containsHeader(string);
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    public String encodeUrl(String string) {
        return string;
    }

    public String encodeURL(String string) {
        return string;
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public void sendError(int n) throws IOException {
        this.response.sendError(200, this.getHTTPMessage(n));
    }

    public void sendError(int n, String string) throws IOException {
        this.response.sendError(200, ESAPI.encoder().encodeForHTML(string));
    }

    public void sendRedirect(String string) throws IOException {
        if (!ESAPI.validator().isValidRedirectLocation("Redirect", string, false)) {
            this.logger.fatal(Logger.SECURITY, false, "Bad redirect location: " + string);
            throw new IOException("Redirect failed");
        }
        this.response.sendRedirect(string);
    }

    public void setBufferSize(int n) {
        this.response.setBufferSize(n);
    }

    public void setCharacterEncoding(String string) {
        this.response.setCharacterEncoding(ESAPI.securityConfiguration().getCharacterEncoding());
    }

    public void setContentLength(int n) {
        this.response.setContentLength(n);
    }

    public void setContentType(String string) {
        this.response.setContentType(string);
    }

    public void setDateHeader(String string, long l) {
        try {
            String string2 = ESAPI.validator().getValidInput("safeSetDateHeader", string, "HTTPHeaderName", 20, false);
            this.response.setDateHeader(string2, l);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid date header name denied", validationException);
        }
    }

    public void setHeader(String string, String string2) {
        try {
            String string3 = StringUtilities.stripControls(string);
            String string4 = StringUtilities.stripControls(string2);
            String string5 = ESAPI.validator().getValidInput("setHeader", string3, "HTTPHeaderName", 20, false);
            String string6 = ESAPI.validator().getValidInput("setHeader", string4, "HTTPHeaderValue", 500, false);
            this.response.setHeader(string5, string6);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid header denied", validationException);
        }
    }

    public void setIntHeader(String string, int n) {
        try {
            String string2 = ESAPI.validator().getValidInput("safeSetDateHeader", string, "HTTPHeaderName", 20, false);
            this.response.setIntHeader(string2, n);
        }
        catch (ValidationException validationException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set invalid int header name denied", validationException);
        }
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    public void setStatus(int n) {
        this.response.setStatus(200);
    }

    public void setStatus(int n, String string) {
        try {
            this.sendError(200, string);
        }
        catch (IOException iOException) {
            this.logger.warning(Logger.SECURITY, false, "Attempt to set response status failed", iOException);
        }
    }

    private String getHTTPMessage(int n) {
        return "HTTP error code: " + n;
    }
}

