/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.ValidationException;

public class SafeRequest
implements HttpServletRequest {
    private HttpServletRequest request;
    private final Logger logger = ESAPI.getLogger("SafeRequest");

    public SafeRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public Object getAttribute(String string) {
        return this.request.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getContextPath() {
        String string = this.request.getContextPath();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP context path: " + string, string, "HTTPContextPath", 150, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public Cookie[] getCookies() {
        Cookie[] cookieArray = this.request.getCookies();
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        for (int i = 0; i < cookieArray.length; ++i) {
            Cookie cookie = cookieArray[i];
            try {
                String string = ESAPI.validator().getValidInput("Cookie name: " + cookie.getName(), cookie.getName(), "HTTPCookieName", 150, false);
                String string2 = ESAPI.validator().getValidInput("Cookie value: " + cookie.getValue(), cookie.getValue(), "HTTPCookieValue", 1000, false);
                int n = cookie.getMaxAge();
                String string3 = cookie.getDomain();
                String string4 = cookie.getPath();
                Cookie cookie2 = new Cookie(string, string2);
                cookie2.setMaxAge(n);
                if (string3 != null) {
                    cookie2.setDomain(ESAPI.validator().getValidInput("Cookie domain: " + string3, string3, "HTTPHeaderValue", 200, false));
                }
                if (string4 != null) {
                    cookie2.setPath(ESAPI.validator().getValidInput("Cookie path: " + string4, string4, "HTTPHeaderValue", 200, false));
                }
                arrayList.add(cookie2);
                continue;
            }
            catch (ValidationException validationException) {
                this.logger.warning(Logger.SECURITY, false, "Skipping bad cookie: " + cookie.getName() + "=" + cookie.getValue(), validationException);
            }
        }
        return arrayList.toArray(new Cookie[arrayList.size()]);
    }

    public long getDateHeader(String string) {
        return this.request.getDateHeader(string);
    }

    public String getHeader(String string) {
        String string2 = this.request.getHeader(string);
        String string3 = "";
        try {
            string3 = ESAPI.validator().getValidInput("HTTP header value: " + string2, string2, "HTTPHeaderValue", 150, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string3;
    }

    public Enumeration getHeaderNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = ESAPI.validator().getValidInput("HTTP header name: " + string, string, "HTTPHeaderName", 150, false);
                vector.add(string2);
            }
            catch (ValidationException validationException) {}
        }
        return vector.elements();
    }

    public Enumeration getHeaders(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.request.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = (String)enumeration.nextElement();
                String string3 = ESAPI.validator().getValidInput("HTTP header value (" + string + "): " + string2, string2, "HTTPHeaderValue", 150, false);
                vector.add(string3);
            }
            catch (ValidationException validationException) {}
        }
        return vector.elements();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public int getIntHeader(String string) {
        return this.request.getIntHeader(string);
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String string) {
        String string2 = this.request.getParameter(string);
        String string3 = "";
        try {
            string3 = ESAPI.validator().getValidInput("HTTP parameter name: " + string, string2, "HTTPParameterValue", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string3;
    }

    public Map getParameterMap() {
        Map map = this.request.getParameterMap();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = ESAPI.validator().getValidInput("HTTP parameter name: " + string, string, "HTTPParameterName", 100, false);
                String[] stringArray = (String[])entry.getValue();
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3;
                    stringArray2[i] = string3 = ESAPI.validator().getValidInput("HTTP parameter value: " + stringArray[i], stringArray[i], "HTTPParameterValue", 2000, false);
                }
                hashMap.put(string2, stringArray2);
            }
            catch (ValidationException validationException) {}
        }
        return hashMap;
    }

    public Enumeration getParameterNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = ESAPI.validator().getValidInput("HTTP parameter name: " + string, string, "HTTPParameterName", 150, false);
                vector.add(string2);
            }
            catch (ValidationException validationException) {}
        }
        return vector.elements();
    }

    public String[] getParameterValues(String string) {
        String[] stringArray = this.request.getParameterValues(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string2 = stringArray[i];
                    String string3 = ESAPI.validator().getValidInput("HTTP parameter value: " + string2, string2, "HTTPParameterValue", 2000, false);
                    arrayList.add(string3);
                    continue;
                }
                catch (ValidationException validationException) {
                    this.logger.warning(Logger.SECURITY, false, "Skipping bad parameter");
                }
            }
        }
        return (String[])arrayList.toArray();
    }

    public String getPathInfo() {
        String string = this.request.getPathInfo();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP path: " + string, string, "HTTPPath", 150, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        String string = this.request.getQueryString();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP query string: " + string, string, "HTTPQueryString", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRealPath(String string) {
        return this.request.getRealPath(string);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getRemoteUser() {
        return ESAPI.authenticator().getCurrentUser().getAccountName();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string.startsWith("WEB-INF")) {
            return this.request.getRequestDispatcher(string);
        }
        return null;
    }

    public String getRequestedSessionId() {
        String string = this.request.getRequestedSessionId();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("Requested cookie: " + string, string, "HTTPJSESSIONID", 50, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public String getRequestURI() {
        String string = this.request.getRequestURI();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP URI: " + string, string, "HTTPURI", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public StringBuffer getRequestURL() {
        String string = this.request.getRequestURL().toString();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP URL: " + string, string, "HTTPURL", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return new StringBuffer(string2);
    }

    public String getScheme() {
        String string = this.request.getScheme();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP scheme: " + string, string, "HTTPScheme", 10, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public String getServerName() {
        String string = this.request.getServerName();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP server name: " + string, string, "HTTPServerName", 100, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public int getServerPort() {
        int n = this.request.getServerPort();
        if (n < 0 || n > 65535) {
            this.logger.warning(Logger.SECURITY, false, "HTTP server port out of range: " + n);
            n = 0;
        }
        return n;
    }

    public String getServletPath() {
        String string = this.request.getServletPath();
        String string2 = "";
        try {
            string2 = ESAPI.validator().getValidInput("HTTP servlet path: " + string, string, "HTTPServletPath", 100, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return string2;
    }

    public HttpSession getSession() {
        HttpSession httpSession = this.request.getSession();
        User user = ESAPI.authenticator().getCurrentUser();
        user.addSession(httpSession);
        if (httpSession.getAttribute("HTTP_ONLY") == null) {
            httpSession.setAttribute("HTTP_ONLY", (Object)"set");
            Cookie cookie = new Cookie("JSESSIONID", httpSession.getId());
            cookie.setMaxAge(-1);
            HttpServletResponse httpServletResponse = ESAPI.currentResponse();
            if (httpServletResponse != null) {
                ESAPI.currentResponse().addCookie(cookie);
            }
        }
        return httpSession;
    }

    public HttpSession getSession(boolean bl) {
        HttpSession httpSession = this.request.getSession(bl);
        if (httpSession == null) {
            return null;
        }
        if (httpSession.getAttribute("HTTP_ONLY") == null) {
            httpSession.setAttribute("HTTP_ONLY", (Object)"set");
            Cookie cookie = new Cookie("JSESSIONID", httpSession.getId());
            cookie.setMaxAge(-1);
            HttpServletResponse httpServletResponse = ESAPI.currentResponse();
            if (httpServletResponse != null) {
                ESAPI.currentResponse().addCookie(cookie);
            }
        }
        return httpSession;
    }

    public Principal getUserPrincipal() {
        return ESAPI.authenticator().getCurrentUser();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String string) {
        return ESAPI.authenticator().getCurrentUser().isInRole(string);
    }

    public void removeAttribute(String string) {
        this.request.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.request.setAttribute(string, object);
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(ESAPI.securityConfiguration().getCharacterEncoding());
    }
}

