/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestRateThrottleFilter
implements Filter {
    private int hits = 5;
    private int period = 10;
    private static final String HITS = "hits";
    private static final String PERIOD = "period";

    public void init(FilterConfig filterConfig) {
        this.hits = Integer.parseInt(filterConfig.getInitParameter(HITS));
        this.period = Integer.parseInt(filterConfig.getInitParameter(PERIOD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession httpSession;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession2 = httpSession = httpServletRequest.getSession(true);
        synchronized (httpSession2) {
            Stack<Date> stack = (Stack<Date>)httpSession.getAttribute("times");
            if (stack == null) {
                stack = new Stack<Date>();
                stack.push(new Date(0L));
                httpSession.setAttribute("times", stack);
            }
            stack.push(new Date());
            if (stack.size() >= this.hits) {
                stack.removeElementAt(0);
            }
            Date date = (Date)stack.get(stack.size() - 1);
            Date date2 = (Date)stack.get(0);
            long l = date.getTime() - date2.getTime();
            if (l < (long)(this.period * 1000)) {
                servletResponse.getWriter().println("Request rate too high");
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

