/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AuthenticationException;

public class ESAPIFilter
implements Filter {
    private final Logger logger = ESAPI.getLogger("ESAPIFilter");
    private static final String[] obfuscate = new String[]{"password"};

    public void init(FilterConfig filterConfig) {
        if (ESAPI.securityConfiguration().getResourceDirectory() == null) {
            String string = filterConfig.getInitParameter("resourceDirectory");
            ESAPI.securityConfiguration().setResourceDirectory(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ESAPI.httpUtilities().setCurrentHTTP(httpServletRequest, httpServletResponse);
        try {
            try {
                ESAPI.authenticator().login(httpServletRequest, httpServletResponse);
            }
            catch (AuthenticationException authenticationException) {
                ESAPI.authenticator().logout();
                httpServletRequest.setAttribute("message", (Object)"Authentication failed");
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("WEB-INF/login.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                ESAPI.authenticator().clearCurrent();
                ESAPI.httpUtilities().setCurrentHTTP(null, null);
                return;
            }
            ESAPI.httpUtilities().logHTTPRequest(httpServletRequest, this.logger, Arrays.asList(obfuscate));
            if (!ESAPI.accessController().isAuthorizedForURL(httpServletRequest.getRequestURI().toString())) {
                httpServletRequest.setAttribute("message", (Object)"Unauthorized");
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("WEB-INF/index.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            if (!ESAPI.validator().isValidHTTPRequest()) {
                httpServletRequest.setAttribute("message", (Object)"Validation error");
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("WEB-INF/index.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            ESAPI.httpUtilities().setSafeContentType(httpServletResponse);
            ESAPI.httpUtilities().setNoCacheHeaders(httpServletResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error(Logger.SECURITY, false, "Error in ESAPI security filter: " + exception.getMessage(), exception);
            httpServletRequest.setAttribute("message", (Object)exception.getMessage());
        }
        finally {
            ESAPI.authenticator().clearCurrent();
            ESAPI.httpUtilities().setCurrentHTTP(null, null);
        }
    }

    public void destroy() {
    }
}

