/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

public class PushbackString {
    private String input;
    private Character pushback;
    private Character temp;
    private int index = 0;
    private int mark = 0;

    public PushbackString(String string) {
        this.input = string;
    }

    public void pushback(Character c) {
        this.pushback = c;
    }

    public int index() {
        return this.index;
    }

    public boolean hasNext() {
        if (this.pushback != null) {
            return true;
        }
        if (this.input == null) {
            return false;
        }
        if (this.input.length() == 0) {
            return false;
        }
        return this.index < this.input.length();
    }

    public Character next() {
        if (this.pushback != null) {
            Character c = this.pushback;
            this.pushback = null;
            return c;
        }
        if (this.input == null) {
            return null;
        }
        if (this.input.length() == 0) {
            return null;
        }
        if (this.index >= this.input.length()) {
            return null;
        }
        return new Character(this.input.charAt(this.index++));
    }

    public Character nextHex() {
        Character c = this.next();
        if (c == null) {
            return null;
        }
        if (this.isHexDigit(c)) {
            return c;
        }
        return null;
    }

    public boolean isHexDigit(Character c) {
        return "0123456789ABCDEFabcdef".indexOf(c.charValue()) != -1;
    }

    public Character peek() {
        if (this.pushback != null) {
            return this.pushback;
        }
        if (this.input == null) {
            return null;
        }
        if (this.input.length() == 0) {
            return null;
        }
        if (this.index >= this.input.length()) {
            return null;
        }
        return new Character(this.input.charAt(this.index));
    }

    public boolean peek(char c) {
        if (this.pushback != null && this.pushback.charValue() == c) {
            return true;
        }
        if (this.input == null) {
            return false;
        }
        if (this.input.length() == 0) {
            return false;
        }
        if (this.index >= this.input.length()) {
            return false;
        }
        return this.input.charAt(this.index) == c;
    }

    public boolean isPushback() {
        return this.pushback != null;
    }

    public void mark() {
        this.temp = this.pushback;
        this.mark = this.index;
    }

    public void reset() {
        this.pushback = this.temp;
        this.index = this.mark;
    }

    protected String remainder() {
        String string = this.input.substring(this.index);
        if (this.pushback != null) {
            string = this.pushback + string;
        }
        return string;
    }
}

