/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class MySQLCodec
implements Codec {
    public static final int MYSQL_MODE = 0;
    public static final int ANSI_MODE = 1;
    private int mode = 0;

    public MySQLCodec(int n) {
        this.mode = n;
    }

    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encodeCharacter(new Character(c)));
        }
        return stringBuffer.toString();
    }

    public String encodeCharacter(Character c) {
        switch (this.mode) {
            case 1: {
                return this.encodeCharacterANSI(c);
            }
            case 0: {
                return this.encodeCharacterMySQL(c);
            }
        }
        return null;
    }

    private String encodeCharacterANSI(Character c) {
        if (c.charValue() == '\'') {
            return "''";
        }
        return "" + c;
    }

    private String encodeCharacterMySQL(Character c) {
        char c2 = c.charValue();
        if (c2 == '\u0000') {
            return "\\0";
        }
        if (c2 == '\b') {
            return "\\b";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 == '\n') {
            return "\\n";
        }
        if (c2 == '\r') {
            return "\\r";
        }
        if (c2 == '\u001a') {
            return "\\z";
        }
        if (c2 == '\"') {
            return "\\\"";
        }
        if (c2 == '%') {
            return "\\%";
        }
        if (c2 == '\'') {
            return "\\'";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        if (c2 == '_') {
            return "\\_";
        }
        return "\\" + c;
    }

    public String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        PushbackString pushbackString = new PushbackString(string);
        while (pushbackString.hasNext()) {
            Character c = this.decodeCharacter(pushbackString);
            if (c != null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(pushbackString.next());
        }
        return stringBuffer.toString();
    }

    public Character decodeCharacter(PushbackString pushbackString) {
        switch (this.mode) {
            case 1: {
                return this.decodeCharacterANSI(pushbackString);
            }
            case 0: {
                return this.decodeCharacterMySQL(pushbackString);
            }
        }
        return null;
    }

    private Character decodeCharacterANSI(PushbackString pushbackString) {
        pushbackString.mark();
        Character c = pushbackString.next();
        if (c == null) {
            pushbackString.reset();
            return null;
        }
        if (c.charValue() != '\'') {
            pushbackString.reset();
            return null;
        }
        Character c2 = pushbackString.next();
        if (c2 == null) {
            pushbackString.reset();
            return null;
        }
        if (c2.charValue() != '\'') {
            pushbackString.reset();
            return null;
        }
        return new Character('\'');
    }

    private Character decodeCharacterMySQL(PushbackString pushbackString) {
        pushbackString.mark();
        Character c = pushbackString.next();
        if (c == null) {
            pushbackString.reset();
            return null;
        }
        if (c.charValue() != '\\') {
            pushbackString.reset();
            return null;
        }
        Character c2 = pushbackString.next();
        if (c2 == null) {
            pushbackString.reset();
            return null;
        }
        if (c2.charValue() == '0') {
            return new Character('\u0000');
        }
        if (c2.charValue() == 'b') {
            return new Character('\b');
        }
        if (c2.charValue() == 't') {
            return new Character('\t');
        }
        if (c2.charValue() == 'n') {
            return new Character('\n');
        }
        if (c2.charValue() == 'r') {
            return new Character('\r');
        }
        if (c2.charValue() == 'z') {
            return new Character('\u001a');
        }
        if (c2.charValue() == '\"') {
            return new Character('\"');
        }
        if (c2.charValue() == '%') {
            return new Character('%');
        }
        if (c2.charValue() == '\'') {
            return new Character('\'');
        }
        if (c2.charValue() == '\\') {
            return new Character('\\');
        }
        if (c2.charValue() == '_') {
            return new Character('_');
        }
        return c2;
    }
}

