/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class JavaScriptCodec
implements Codec {
    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encodeCharacter(new Character(c)));
        }
        return stringBuffer.toString();
    }

    public String encodeCharacter(Character c) {
        char c2 = c.charValue();
        if (c2 == '\u0000') {
            return "\\0";
        }
        if (c2 == '\b') {
            return "\\b";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 == '\n') {
            return "\\n";
        }
        if (c2 == '\u000b') {
            return "\\v";
        }
        if (c2 == '\f') {
            return "\\f";
        }
        if (c2 == '\r') {
            return "\\r";
        }
        if (c2 == '\"') {
            return "\\\"";
        }
        if (c2 == '\'') {
            return "\\'";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        String string = Integer.toHexString(c2);
        if (c2 <= '\u0100') {
            String string2 = "00".substring(string.length());
            return "\\x" + string2 + string.toUpperCase();
        }
        String string3 = "0000".substring(string.length());
        return "\\u" + string3 + string.toUpperCase();
    }

    public String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        PushbackString pushbackString = new PushbackString(string);
        while (pushbackString.hasNext()) {
            Character c = this.decodeCharacter(pushbackString);
            if (c != null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(pushbackString.next());
        }
        return stringBuffer.toString();
    }

    public Character decodeCharacter(PushbackString pushbackString) {
        pushbackString.mark();
        Character c = pushbackString.next();
        if (c == null) {
            pushbackString.reset();
            return null;
        }
        if (c.charValue() != '\\') {
            pushbackString.reset();
            return null;
        }
        Character c2 = pushbackString.next();
        if (c2 == null) {
            pushbackString.reset();
            return null;
        }
        if (c2.charValue() == '0') {
            return new Character('\u0000');
        }
        if (c2.charValue() == 'b') {
            return new Character('\b');
        }
        if (c2.charValue() == 't') {
            return new Character('\t');
        }
        if (c2.charValue() == 'n') {
            return new Character('\n');
        }
        if (c2.charValue() == 'v') {
            return new Character('\u000b');
        }
        if (c2.charValue() == 'f') {
            return new Character('\f');
        }
        if (c2.charValue() == 'r') {
            return new Character('\r');
        }
        if (c2.charValue() == '\"') {
            return new Character('\"');
        }
        if (c2.charValue() == '\'') {
            return new Character('\'');
        }
        if (c2.charValue() == '\\') {
            return new Character('\\');
        }
        if (Character.toLowerCase(c2.charValue()) == 'x') {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < 2; ++n) {
                Character c3 = pushbackString.nextHex();
                if (c3 == null) continue;
                stringBuffer.append(c3);
            }
            if (stringBuffer.length() == 2) {
                try {
                    n = Integer.parseInt(stringBuffer.toString(), 16);
                    return new Character((char)n);
                }
                catch (NumberFormatException numberFormatException) {
                    pushbackString.reset();
                    return null;
                }
            }
        } else if (Character.toLowerCase(c2.charValue()) == 'u') {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < 4; ++n) {
                Character c4 = pushbackString.nextHex();
                if (c4 == null) continue;
                stringBuffer.append(c4);
            }
            if (stringBuffer.length() == 4) {
                try {
                    n = Integer.parseInt(stringBuffer.toString(), 16);
                    return new Character((char)n);
                }
                catch (NumberFormatException numberFormatException) {
                    pushbackString.reset();
                    return null;
                }
            }
        }
        return c2;
    }
}

