/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.owasp.esapi.util.NullSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTrie<T>
implements Map<CharSequence, T> {
    private Node<T> root;
    private int maxKeyLen;
    private int size;

    public HashTrie() {
        this.clear();
    }

    public Map.Entry<CharSequence, T> getLongestMatch(CharSequence charSequence) {
        if (this.root == null || charSequence == null) {
            return null;
        }
        return this.root.getLongestMatch(charSequence, 0);
    }

    public Map.Entry<CharSequence, T> getLongestMatch(PushbackReader pushbackReader) throws IOException {
        if (this.root == null || pushbackReader == null) {
            return null;
        }
        return this.root.getLongestMatch(pushbackReader, new StringBuilder());
    }

    public int getMaxKeyLength() {
        return this.maxKeyLen;
    }

    @Override
    public void clear() {
        this.root = null;
        this.maxKeyLen = -1;
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.root == null) {
            return false;
        }
        return this.root.containsValue(object);
    }

    @Override
    public T put(CharSequence charSequence, T t) throws NullPointerException {
        T t2;
        int n = charSequence.length();
        if (charSequence == null) {
            throw new NullPointerException("Null keys are not handled");
        }
        if (t == null) {
            throw new NullPointerException("Null values are not handled");
        }
        if (this.root == null) {
            this.root = new Node();
        }
        if ((t2 = this.root.put(charSequence, 0, t)) != null) {
            return t2;
        }
        if (n > this.maxKeyLen) {
            this.maxKeyLen = n;
        }
        ++this.size;
        return null;
    }

    @Override
    public T remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends CharSequence, ? extends T> map) {
        for (Map.Entry<CharSequence, T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<CharSequence> keySet() {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>(this.size);
        if (this.root == null) {
            return hashSet;
        }
        return this.root.keySet(new StringBuilder(), hashSet);
    }

    @Override
    public Collection<T> values() {
        ArrayList arrayList = new ArrayList(this.size());
        if (this.root == null) {
            return arrayList;
        }
        return this.root.values(arrayList);
    }

    @Override
    public Set<Map.Entry<CharSequence, T>> entrySet() {
        HashSet<Map.Entry<CharSequence, T>> hashSet = new HashSet<Map.Entry<CharSequence, T>>(this.size());
        if (this.root == null) {
            return hashSet;
        }
        return this.root.entrySet(new StringBuilder(), hashSet);
    }

    @Override
    public T get(Object object) {
        if (this.root == null || object == null) {
            return null;
        }
        if (!(object instanceof CharSequence)) {
            return null;
        }
        return this.root.get((CharSequence)object, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)object).entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append("{ ");
        for (Map.Entry<CharSequence, T> entry : this.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.toString());
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private T value = null;
        private Map<Character, Node<T>> nextMap;

        private Node() {
        }

        private static <T> Map<Character, Node<T>> newNodeMap() {
            return new HashMap<Character, Node<T>>();
        }

        private static <T> Map<Character, Node<T>> newNodeMap(Map<Character, Node<T>> map) {
            return new HashMap<Character, Node<T>>(map);
        }

        void setValue(T t) {
            this.value = t;
        }

        Node<T> getNextNode(Character c) {
            if (this.nextMap == null) {
                return null;
            }
            return this.nextMap.get(c);
        }

        T put(CharSequence charSequence, int n, T t) {
            Node<T> node;
            if (charSequence.length() == n) {
                T t2 = this.value;
                this.setValue(t);
                return t2;
            }
            Character c = Character.valueOf(charSequence.charAt(n));
            if (this.nextMap == null) {
                this.nextMap = Node.newNodeMap();
                node = new Node<T>();
                this.nextMap.put(c, node);
            } else {
                node = this.nextMap.get(c);
                if (node == null) {
                    node = new Node<T>();
                    this.nextMap.put(c, node);
                }
            }
            return node.put(charSequence, n + 1, t);
        }

        T get(CharSequence charSequence, int n) {
            if (charSequence.length() <= n) {
                return this.value;
            }
            Node<T> node = this.getNextNode(Character.valueOf(charSequence.charAt(n)));
            if (node == null) {
                return null;
            }
            return node.get(charSequence, n + 1);
        }

        Entry<T> getLongestMatch(CharSequence charSequence, int n) {
            if (charSequence.length() <= n) {
                return Entry.newInstanceIfNeeded(charSequence, this.value);
            }
            Node<T> node = this.getNextNode(Character.valueOf(charSequence.charAt(n)));
            if (node == null) {
                return Entry.newInstanceIfNeeded(charSequence, n, this.value);
            }
            Entry<T> entry = node.getLongestMatch(charSequence, n + 1);
            if (entry != null) {
                return entry;
            }
            return Entry.newInstanceIfNeeded(charSequence, n, this.value);
        }

        Entry<T> getLongestMatch(PushbackReader pushbackReader, StringBuilder stringBuilder) throws IOException {
            int n = pushbackReader.read();
            if (n < 0) {
                return Entry.newInstanceIfNeeded(stringBuilder, this.value);
            }
            char c = (char)n;
            int n2 = stringBuilder.length();
            stringBuilder.append(c);
            Node<T> node = this.getNextNode(Character.valueOf(c));
            if (node == null) {
                return Entry.newInstanceIfNeeded(stringBuilder, this.value);
            }
            Entry<T> entry = node.getLongestMatch(pushbackReader, stringBuilder);
            if (entry != null) {
                return entry;
            }
            stringBuilder.setLength(n2);
            pushbackReader.unread(n);
            return Entry.newInstanceIfNeeded(stringBuilder, this.value);
        }

        void remap() {
            if (this.nextMap == null) {
                return;
            }
            this.nextMap = Node.newNodeMap(this.nextMap);
            for (Node<T> node : this.nextMap.values()) {
                node.remap();
            }
        }

        boolean containsValue(Object object) {
            if (this.value != null && object.equals(this.value)) {
                return true;
            }
            if (this.nextMap == null) {
                return false;
            }
            for (Node<T> node : this.nextMap.values()) {
                if (!node.containsValue(object)) continue;
                return true;
            }
            return false;
        }

        Collection<T> values(Collection<T> collection) {
            if (this.value != null) {
                collection.add(this.value);
            }
            if (this.nextMap == null) {
                return collection;
            }
            for (Node<T> node : this.nextMap.values()) {
                node.values(collection);
            }
            return collection;
        }

        Set<CharSequence> keySet(StringBuilder stringBuilder, Set<CharSequence> set) {
            int n = stringBuilder.length();
            if (this.value != null) {
                set.add(stringBuilder.toString());
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                stringBuilder.append('X');
                for (Map.Entry<Character, Node<T>> entry : this.nextMap.entrySet()) {
                    stringBuilder.setCharAt(n, entry.getKey().charValue());
                    entry.getValue().keySet(stringBuilder, set);
                }
                stringBuilder.setLength(n);
            }
            return set;
        }

        Set<Map.Entry<CharSequence, T>> entrySet(StringBuilder stringBuilder, Set<Map.Entry<CharSequence, T>> set) {
            int n = stringBuilder.length();
            if (this.value != null) {
                set.add(new Entry<T>(stringBuilder.toString(), this.value));
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                stringBuilder.append('X');
                for (Map.Entry<Character, Node<T>> entry : this.nextMap.entrySet()) {
                    stringBuilder.setCharAt(n, entry.getKey().charValue());
                    entry.getValue().entrySet(stringBuilder, set);
                }
                stringBuilder.setLength(n);
            }
            return set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T>
    implements Map.Entry<CharSequence, T> {
        private CharSequence key;
        private T value;

        Entry(CharSequence charSequence, T t) {
            this.key = charSequence;
            this.value = t;
        }

        static <T> Entry<T> newInstanceIfNeeded(CharSequence charSequence, int n, T t) {
            if (t == null || charSequence == null) {
                return null;
            }
            if (charSequence.length() > n) {
                charSequence = charSequence.subSequence(0, n);
            }
            return new Entry<T>(charSequence, t);
        }

        static <T> Entry<T> newInstanceIfNeeded(CharSequence charSequence, T t) {
            if (t == null || charSequence == null) {
                return null;
            }
            return new Entry<T>(charSequence, t);
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T t) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Map.Entry entry) {
            return NullSafe.equals(this.key, entry.getKey()) && NullSafe.equals(this.value, entry.getValue());
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                return this.equals((Map.Entry)object);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return NullSafe.hashCode(this.key) ^ NullSafe.hashCode(this.value);
        }

        public String toString() {
            return NullSafe.toString(this.key) + " => " + NullSafe.toString(this.value);
        }
    }
}

