/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.HashTrie;
import org.owasp.esapi.codecs.PushbackString;

public class HTMLEntityCodec
implements Codec {
    private static HashMap characterToEntityMap;
    private static HashTrie entityToCharacterMap;

    public HTMLEntityCodec() {
        this.initializeMaps();
    }

    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(this.encodeCharacter(new Character(string.charAt(i))));
        }
        return stringBuffer.toString();
    }

    public String encodeCharacter(Character c) {
        String string = (String)characterToEntityMap.get(c);
        if (string != null) {
            return "&" + string + ";";
        }
        return "&#" + c.charValue() + ";";
    }

    public String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        PushbackString pushbackString = new PushbackString(string);
        while (pushbackString.hasNext()) {
            Character c = this.decodeCharacter(pushbackString);
            if (c != null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(pushbackString.next());
        }
        return stringBuffer.toString();
    }

    public Character decodeCharacter(PushbackString pushbackString) {
        pushbackString.mark();
        Character c = pushbackString.next();
        if (c == null) {
            pushbackString.reset();
            return null;
        }
        if (c.charValue() != '&') {
            pushbackString.reset();
            return null;
        }
        Character c2 = pushbackString.next();
        if (c2 == null) {
            pushbackString.reset();
            return null;
        }
        if (c2.charValue() == '#') {
            Character c3 = this.getNumericEntity(pushbackString);
            if (c3 != null) {
                return c3;
            }
        } else if (Character.isLetter(c2.charValue())) {
            pushbackString.pushback(c2);
            Character c4 = this.getNamedEntity(pushbackString);
            if (c4 != null) {
                return c4;
            }
        }
        pushbackString.reset();
        return null;
    }

    private Character getNumericEntity(PushbackString pushbackString) {
        Character c = pushbackString.peek();
        if (c == null) {
            return null;
        }
        if (c.charValue() == 'x' || c.charValue() == 'X') {
            pushbackString.next();
            return this.parseHex(pushbackString);
        }
        return this.parseNumber(pushbackString);
    }

    private Character parseNumber(PushbackString pushbackString) {
        StringBuffer stringBuffer = new StringBuffer();
        while (pushbackString.hasNext()) {
            Character c = pushbackString.peek();
            if (Character.isDigit(c.charValue())) {
                stringBuffer.append(c);
                pushbackString.next();
                continue;
            }
            if (c.charValue() != ';') break;
            pushbackString.next();
            break;
        }
        try {
            int n = Integer.parseInt(stringBuffer.toString());
            return new Character((char)n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Character parseHex(PushbackString pushbackString) {
        StringBuffer stringBuffer = new StringBuffer();
        while (pushbackString.hasNext()) {
            Character c = pushbackString.peek();
            if ("0123456789ABCDEFabcdef".indexOf(c.charValue()) != -1) {
                stringBuffer.append(c);
                pushbackString.next();
                continue;
            }
            if (c.charValue() != ';') break;
            pushbackString.next();
            break;
        }
        try {
            int n = Integer.parseInt(stringBuffer.toString(), 16);
            return new Character((char)n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Character getNamedEntity(PushbackString pushbackString) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Math.min(pushbackString.remainder().length(), entityToCharacterMap.getMaxKeyLength());
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(Character.toLowerCase(pushbackString.next().charValue()));
        }
        Map.Entry entry = entityToCharacterMap.getLongestMatch(stringBuilder);
        if (entry == null) {
            return null;
        }
        pushbackString.reset();
        pushbackString.next();
        n2 = entry.getKey().length();
        for (n = 0; n < n2; ++n) {
            pushbackString.next();
        }
        if (pushbackString.peek(';')) {
            pushbackString.next();
        }
        return (Character)entry.getValue();
    }

    private void initializeMaps() {
        String[] stringArray = new String[]{"quot", "amp", "lt", "gt", "nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml", "OElig", "oelig", "Scaron", "scaron", "Yuml", "fnof", "circ", "tilde", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv", "ensp", "emsp", "thinsp", "zwnj", "zwj", "lrm", "rlm", "ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo", "rdquo", "bdquo", "dagger", "Dagger", "bull", "hellip", "permil", "prime", "Prime", "lsaquo", "rsaquo", "oline", "frasl", "euro", "image", "weierp", "real", "trade", "alefsym", "larr", "uarr", "rarr", "darr", "harr", "crarr", "lArr", "uArr", "rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla", "isin", "notin", "ni", "prod", "sum", "minus", "lowast", "radic", "prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4", "sim", "cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup", "nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot", "lceil", "rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs", "hearts", "diams"};
        char[] cArray = new char[]{'\"', '&', '<', '>', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\u0152', '\u0153', '\u0160', '\u0161', '\u0178', '\u0192', '\u02c6', '\u02dc', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03d1', '\u03d2', '\u03d6', '\u2002', '\u2003', '\u2009', '\u200c', '\u200d', '\u200e', '\u200f', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2032', '\u2033', '\u2039', '\u203a', '\u203e', '\u2044', '\u20ac', '\u2111', '\u2118', '\u211c', '\u2122', '\u2135', '\u2190', '\u2191', '\u2192', '\u2193', '\u2194', '\u21b5', '\u21d0', '\u21d1', '\u21d2', '\u21d3', '\u21d4', '\u2200', '\u2202', '\u2203', '\u2205', '\u2207', '\u2208', '\u2209', '\u220b', '\u220f', '\u2211', '\u2212', '\u2217', '\u221a', '\u221d', '\u221e', '\u2220', '\u2227', '\u2228', '\u2229', '\u222a', '\u222b', '\u2234', '\u223c', '\u2245', '\u2248', '\u2260', '\u2261', '\u2264', '\u2265', '\u2282', '\u2283', '\u2284', '\u2286', '\u2287', '\u2295', '\u2297', '\u22a5', '\u22c5', '\u2308', '\u2309', '\u230a', '\u230b', '\u2329', '\u232a', '\u25ca', '\u2660', '\u2663', '\u2665', '\u2666'};
        characterToEntityMap = new HashMap(stringArray.length);
        entityToCharacterMap = new HashTrie();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Character c = new Character(cArray[i]);
            entityToCharacterMap.put(string, c);
            characterToEntityMap.put(c, string);
        }
    }
}

