/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class CSSCodec
implements Codec {
    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.encodeCharacter(new Character(c)));
        }
        return stringBuffer.toString();
    }

    public String encodeCharacter(Character c) {
        char c2 = c.charValue();
        if (c2 <= '\u0100') {
            return "\\" + c2;
        }
        String string = Integer.toHexString(c2);
        return "\\" + string.toUpperCase() + " ";
    }

    public String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        PushbackString pushbackString = new PushbackString(string);
        while (pushbackString.hasNext()) {
            Character c = this.decodeCharacter(pushbackString);
            if (c != null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(pushbackString.next());
        }
        return stringBuffer.toString();
    }

    public Character decodeCharacter(PushbackString pushbackString) {
        pushbackString.mark();
        Character c = pushbackString.next();
        if (c == null) {
            pushbackString.reset();
            return null;
        }
        if (c.charValue() != '\\') {
            pushbackString.reset();
            return null;
        }
        Character c2 = pushbackString.next();
        if (c2 == null) {
            pushbackString.reset();
            return null;
        }
        System.out.println(">>>" + c2);
        if (pushbackString.isHexDigit(c2)) {
            Character c3;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c2);
            for (n = 0; n < 5 && (c3 = pushbackString.next()) != null && c3.charValue() != ' '; ++n) {
                if (!pushbackString.isHexDigit(c3)) {
                    pushbackString.pushback(c3);
                    break;
                }
                stringBuffer.append(c3);
            }
            try {
                n = Integer.parseInt(stringBuffer.toString(), 16);
                return new Character((char)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return c2;
    }
}

