/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.esapi.errors.ValidationException;

public class SafeFile
extends File {
    private static final long serialVersionUID = 1L;
    Pattern percents = Pattern.compile("(%)([0-9a-fA-F])([0-9a-fA-F])");
    Pattern dirblacklist = Pattern.compile("([*?<>|])");
    Pattern fileblacklist = Pattern.compile("([\\\\/:*?<>|])");

    public SafeFile(String string) throws ValidationException {
        super(string);
        this.doDirCheck(this.getParent());
        this.doFileCheck(this.getName());
    }

    public SafeFile(String string, String string2) throws ValidationException {
        super(string, string2);
        this.doDirCheck(this.getParent());
        this.doFileCheck(this.getName());
    }

    public SafeFile(File file, String string) throws ValidationException {
        super(file, string);
        this.doDirCheck(this.getParent());
        this.doFileCheck(this.getName());
    }

    public SafeFile(URI uRI) throws ValidationException {
        super(uRI);
        this.doDirCheck(this.getParent());
        this.doFileCheck(this.getName());
    }

    private void doDirCheck(String string) throws ValidationException {
        Matcher matcher = this.dirblacklist.matcher(string);
        if (matcher.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + string + ") contains illegal character: " + matcher.group());
        }
        Matcher matcher2 = this.percents.matcher(string);
        if (matcher2.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + string + ") contains encoded characters: " + matcher2.group());
        }
        int n = this.containsUnprintableCharacters(string);
        if (n != -1) {
            throw new ValidationException("Invalid directory", "Directory path (" + string + ") contains unprintable character: " + n);
        }
    }

    private void doFileCheck(String string) throws ValidationException {
        Matcher matcher = this.fileblacklist.matcher(string);
        if (matcher.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + string + ") contains illegal character: " + matcher.group());
        }
        Matcher matcher2 = this.percents.matcher(string);
        if (matcher2.find()) {
            throw new ValidationException("Invalid file", "File path (" + string + ") contains encoded characters: " + matcher2.group());
        }
        int n = this.containsUnprintableCharacters(string);
        if (n != -1) {
            throw new ValidationException("Invalid file", "File path (" + string + ") contains unprintable character: " + n);
        }
    }

    private int containsUnprintableCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return c;
        }
        return -1;
    }
}

