/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.filters.SafeRequest;
import org.owasp.esapi.filters.SafeResponse;

public interface HTTPUtilities {
    public static final String REMEMBER_TOKEN_COOKIE_NAME = "ESAPIRememberToken";

    public void assertSecureRequest(HttpServletRequest var1) throws AccessControlException;

    public String addCSRFToken(String var1);

    public Cookie getCookie(HttpServletRequest var1, String var2);

    public String getCSRFToken();

    public HttpSession changeSessionIdentifier(HttpServletRequest var1) throws AuthenticationException;

    public void verifyCSRFToken(HttpServletRequest var1) throws IntrusionException;

    public String decryptHiddenField(String var1);

    public String setRememberToken(HttpServletRequest var1, HttpServletResponse var2, String var3, int var4, String var5, String var6);

    public String encryptHiddenField(String var1) throws EncryptionException;

    public String encryptQueryString(String var1) throws EncryptionException;

    public Map decryptQueryString(String var1) throws EncryptionException;

    public List getSafeFileUploads(HttpServletRequest var1, File var2, File var3) throws ValidationException;

    public Map decryptStateFromCookie(HttpServletRequest var1) throws EncryptionException;

    public void killAllCookies(HttpServletRequest var1, HttpServletResponse var2);

    public void killCookie(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public void encryptStateInCookie(HttpServletResponse var1, Map var2) throws EncryptionException;

    public void safeSendForward(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws AccessControlException, ServletException, IOException;

    public void setSafeContentType(HttpServletResponse var1);

    public void setNoCacheHeaders(HttpServletResponse var1);

    public void setCurrentHTTP(HttpServletRequest var1, HttpServletResponse var2);

    public SafeRequest getCurrentRequest();

    public SafeResponse getCurrentResponse();

    public void logHTTPRequest(HttpServletRequest var1, Logger var2);

    public void logHTTPRequest(HttpServletRequest var1, Logger var2, List var3);
}

