/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Executor;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.IntrusionDetector;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.Validator;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.DefaultExecutor;
import org.owasp.esapi.reference.DefaultHTTPUtilities;
import org.owasp.esapi.reference.DefaultIntrusionDetector;
import org.owasp.esapi.reference.DefaultRandomizer;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;
import org.owasp.esapi.reference.DefaultValidator;
import org.owasp.esapi.reference.FileBasedAccessController;
import org.owasp.esapi.reference.FileBasedAuthenticator;
import org.owasp.esapi.reference.JavaEncryptor;
import org.owasp.esapi.reference.JavaLogFactory;

public class ESAPI {
    private static AccessController accessController = null;
    private static Authenticator authenticator = null;
    private static Encoder encoder = null;
    private static Encryptor encryptor = null;
    private static Executor executor = null;
    private static HTTPUtilities httpUtilities = null;
    private static IntrusionDetector intrusionDetector = null;
    private static LogFactory logFactory = null;
    private static Logger defaultLogger = null;
    private static Randomizer randomizer = null;
    private static SecurityConfiguration securityConfiguration = null;
    private static Validator validator = null;

    private ESAPI() {
    }

    public static HttpServletRequest currentRequest() {
        return ESAPI.httpUtilities().getCurrentRequest();
    }

    public static HttpServletResponse currentResponse() {
        return ESAPI.httpUtilities().getCurrentResponse();
    }

    public static AccessController accessController() {
        if (accessController == null) {
            accessController = new FileBasedAccessController();
        }
        return accessController;
    }

    public static void setAccessController(AccessController accessController) {
        ESAPI.accessController = accessController;
    }

    public static Authenticator authenticator() {
        if (authenticator == null) {
            authenticator = new FileBasedAuthenticator();
        }
        return authenticator;
    }

    public static void setAuthenticator(Authenticator authenticator) {
        ESAPI.authenticator = authenticator;
    }

    public static Encoder encoder() {
        if (encoder == null) {
            encoder = new DefaultEncoder();
        }
        return encoder;
    }

    public static void setEncoder(Encoder encoder) {
        ESAPI.encoder = encoder;
    }

    public static Encryptor encryptor() {
        if (encryptor == null) {
            encryptor = new JavaEncryptor();
        }
        return encryptor;
    }

    public static void setEncryptor(Encryptor encryptor) {
        ESAPI.encryptor = encryptor;
    }

    public static Executor executor() {
        if (executor == null) {
            executor = new DefaultExecutor();
        }
        return executor;
    }

    public static void setExecutor(Executor executor) {
        ESAPI.executor = executor;
    }

    public static HTTPUtilities httpUtilities() {
        if (httpUtilities == null) {
            httpUtilities = new DefaultHTTPUtilities();
        }
        return httpUtilities;
    }

    public static void setHttpUtilities(HTTPUtilities hTTPUtilities) {
        httpUtilities = hTTPUtilities;
    }

    public static IntrusionDetector intrusionDetector() {
        if (intrusionDetector == null) {
            intrusionDetector = new DefaultIntrusionDetector();
        }
        return intrusionDetector;
    }

    public static void setIntrusionDetector(IntrusionDetector intrusionDetector) {
        ESAPI.intrusionDetector = intrusionDetector;
    }

    private static LogFactory logFactory() {
        if (logFactory == null) {
            logFactory = new JavaLogFactory(ESAPI.securityConfiguration().getApplicationName());
        }
        return logFactory;
    }

    public static Logger getLogger(Class clazz) {
        return ESAPI.logFactory().getLogger(clazz);
    }

    public static Logger getLogger(String string) {
        return ESAPI.logFactory().getLogger(string);
    }

    public static Logger log() {
        if (defaultLogger == null) {
            defaultLogger = ESAPI.logFactory().getLogger("DefaultLogger");
        }
        return defaultLogger;
    }

    public static void setLogFactory(LogFactory logFactory) {
        ESAPI.logFactory = logFactory;
    }

    public static Randomizer randomizer() {
        if (randomizer == null) {
            randomizer = new DefaultRandomizer();
        }
        return randomizer;
    }

    public static void setRandomizer(Randomizer randomizer) {
        ESAPI.randomizer = randomizer;
    }

    public static SecurityConfiguration securityConfiguration() {
        if (securityConfiguration == null) {
            securityConfiguration = new DefaultSecurityConfiguration();
        }
        return securityConfiguration;
    }

    public static void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        ESAPI.securityConfiguration = securityConfiguration;
    }

    public static Validator validator() {
        if (validator == null) {
            validator = new DefaultValidator();
        }
        return validator;
    }

    public static void setValidator(Validator validator) {
        ESAPI.validator = validator;
    }
}

