/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util.versitio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.wimpi.pim.util.versitio.versitException;
import net.wimpi.pim.util.versitio.versitInputStream;
import net.wimpi.pim.util.versitio.versitItem;

public class versitParser {
    private versitInputStream m_Input;
    private List m_Items;
    private List m_CardObjects;
    private List m_CalObjects;
    private boolean m_Validating = true;

    public versitParser(InputStream inputStream) {
        this.m_Input = new versitInputStream(inputStream);
        this.m_Items = Collections.synchronizedList(new ArrayList(35));
    }

    public versitParser(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.m_Input = new versitInputStream(inputStream, string);
        this.m_Items = Collections.synchronizedList(new ArrayList(35));
    }

    public void parse() throws versitException {
        try {
            while (this.m_Input.hasLine()) {
                String string = this.m_Input.readLine();
                if (string == null || string.length() <= 0) continue;
                this.m_Items.add(versitItem.createItem(string));
            }
            this.bundleObjects();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isValidating() {
        return this.m_Validating;
    }

    public void setValidating(boolean bl) {
        this.m_Validating = true;
    }

    private void bundleObjects() throws versitException {
        this.m_CardObjects = new ArrayList(3);
        this.m_CalObjects = new ArrayList(3);
        List list = null;
        versitItem versitItem2 = null;
        int n = 0;
        ListIterator listIterator = this.m_Items.listIterator();
        while (listIterator.hasNext()) {
            versitItem2 = (versitItem)listIterator.next();
            if (versitItem2.getIdentifier().equalsIgnoreCase("BEGIN")) {
                int n2;
                if (versitItem2.getValue().equalsIgnoreCase("VCARD")) {
                    n2 = this.findObjectEnd("VCARD", listIterator, n);
                    list = this.m_Items.subList(n + 1, n2);
                    n = n2;
                    if (this.isValidating()) {
                        this.validateCard(list);
                    }
                    this.m_CardObjects.add(list);
                } else if (versitItem2.getValue().equalsIgnoreCase("VCALENDAR")) {
                    n2 = this.findObjectEnd("VCALENDAR", listIterator, n);
                    list = this.m_Items.subList(n + 1, n2);
                    n = n2;
                    this.m_CalObjects.add(list);
                }
            }
            ++n;
        }
    }

    public List getCardObjects() {
        return this.m_CardObjects;
    }

    public List getCalendarObjects() {
        return this.m_CalObjects;
    }

    private int findObjectEnd(String string, Iterator iterator, int n) throws versitException {
        boolean bl = false;
        versitItem versitItem2 = null;
        while (iterator.hasNext() || !bl) {
            ++n;
            versitItem2 = (versitItem)iterator.next();
            if (!versitItem2.getIdentifier().equalsIgnoreCase("END") || !versitItem2.getValue().equalsIgnoreCase(string)) continue;
            return n;
        }
        if (!bl) {
            throw new versitException("Object end token missing.");
        }
        return n;
    }

    private void validateCard(List list) throws versitException {
        String string = this.getVersion(list);
        if (string.equals("2.1")) {
            String[] stringArray = new String[]{"N"};
            if (!this.hasMandatoryTokens(list, stringArray)) {
                throw new versitException("Mandatory tokens missing.");
            }
        } else if (string.equals("3.0")) {
            String[] stringArray = new String[]{"N", "FN"};
            if (!this.hasMandatoryTokens(list, stringArray)) {
                throw new versitException("Mandatory tokens missing.");
            }
        } else {
            throw new versitException("Factory cannot handle format version " + string + ".");
        }
    }

    private String getVersion(List list) throws versitException {
        versitItem versitItem2 = null;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            versitItem2 = (versitItem)listIterator.next();
            if (!versitItem2.getIdentifier().equalsIgnoreCase("VERSION")) continue;
            return versitItem2.getValue();
        }
        throw new versitException("vCard invalid: the version property is mandatory.");
    }

    private boolean hasMandatoryTokens(List list, String[] stringArray) {
        versitItem versitItem2 = null;
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            versitItem2 = (versitItem)listIterator.next();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!versitItem2.getIdentifier().equalsIgnoreCase(stringArray[i])) continue;
                ++n;
            }
        }
        return n == stringArray.length;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(file);
            versitParser versitParser2 = new versitParser(fileInputStream);
            versitParser2.parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

