/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util.versitio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitException;

public class versitItem {
    private String m_Identifier;
    private String m_Group;
    private String m_unprocessedParameters;
    private String m_Value;
    private HashMap m_Params;

    public versitItem(String string) {
        this.m_Params = new HashMap();
        this.setIdentifier(string);
    }

    public versitItem(String string, String string2) {
        this.m_Params = new HashMap();
        this.setIdentifier(string);
        this.setValue(string2);
    }

    private versitItem() {
    }

    public void setIdentifier(String string) {
        this.m_Identifier = string;
    }

    public String getIdentifier() {
        return this.m_Identifier;
    }

    public String getGroup() {
        return this.m_Group;
    }

    public void setGroup(String string) {
        this.m_Group = string;
    }

    public boolean hasGroup() {
        return this.m_Group != null;
    }

    protected void setUnprocessedParameters(String string) {
        this.m_unprocessedParameters = string;
    }

    public String getUnprocessedParameters() {
        return this.m_unprocessedParameters;
    }

    public String[] getParameter(String string) {
        if (this.m_Params != null) {
            Object v = this.m_Params.get(string);
            if (v instanceof String) {
                String[] stringArray = new String[]{(String)v};
                return stringArray;
            }
            return (String[])v;
        }
        return null;
    }

    public Map getParameters() {
        return this.m_Params;
    }

    public boolean hasParameters() {
        return this.m_Params != null;
    }

    public void addParameter(String string, String string2) {
        String[] stringArray;
        if (this.m_Params.containsKey(string)) {
            String[] stringArray2 = (String[])this.m_Params.get(string);
            stringArray = new String[stringArray2.length + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = stringArray2[i];
            }
            stringArray[stringArray2.length] = string2;
        } else {
            stringArray = new String[]{string2};
        }
        this.m_Params.put(string, stringArray);
    }

    public void setValue(String string) {
        this.m_Value = string;
    }

    public String getValue() {
        return this.m_Value;
    }

    public String getDecodedValue() {
        String[] stringArray = this.getParameter("ENCODING");
        if (stringArray != null && stringArray.length > 0) {
            if ("QUOTED-PRINTABLE".equals(stringArray[0])) {
                return EncodingUtility.decodeQP(this.m_Value);
            }
            if ("BASE64".equals(stringArray[0])) {
                return new String(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(this.getValue().getBytes())));
            }
            return this.m_Value;
        }
        return this.m_Value;
    }

    private void setGroupAndId(String string) {
        int n = string.indexOf(46);
        if (n != -1) {
            this.m_Group = string.substring(0, n);
            this.m_Identifier = string.substring(n + 1, string.length());
        } else {
            this.m_Identifier = string.toUpperCase();
        }
    }

    private void processParameters() {
        String[] stringArray = StringUtil.split(this.getUnprocessedParameters(), ";");
        this.m_Params = new HashMap((int)((double)stringArray.length * 1.35));
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = StringUtil.split(stringArray[i], "=");
            if (stringArray2.length == 1) {
                this.addParameter("default".toUpperCase(), stringArray2[0]);
                continue;
            }
            stringArray3 = StringUtil.splitList(stringArray2[1]);
            if (stringArray3.length == 1) {
                this.addParameter(stringArray2[0].toUpperCase(), stringArray2[1]);
                continue;
            }
            for (int j = 0; j < stringArray3.length; ++j) {
                this.addParameter(stringArray2[0].toUpperCase(), stringArray3[j]);
            }
        }
    }

    public static versitItem createItem(String string) throws versitException {
        versitItem versitItem2 = new versitItem();
        String string2 = "";
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            versitItem2.setValue(string.substring(n + 1, string.length()));
            n = string2.indexOf(59);
            if (n != -1) {
                versitItem2.setGroupAndId(string2.substring(0, n));
                versitItem2.setUnprocessedParameters(string2.substring(n + 1, string2.length()));
                versitItem2.processParameters();
            } else {
                versitItem2.setGroupAndId(string2);
            }
        } else {
            throw new versitException("versit format seems invalid.");
        }
        return versitItem2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Group != null && this.m_Group.length() > 0) {
            stringBuffer.append(this.m_Group).append(".");
        }
        stringBuffer.append(this.m_Identifier);
        Set set = this.m_Params.keySet();
        int n = 0;
        if (set.size() > 0) {
            stringBuffer.append(";");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = this.getParameter(string);
            if (stringArray != null) {
                stringBuffer.append(string).append("=").append(StringUtil.joinList(stringArray));
                if (iterator.hasNext()) {
                    stringBuffer.append(";");
                }
            }
            ++n;
        }
        stringBuffer.append(":");
        stringBuffer.append(this.fold(stringBuffer.length(), this.m_Value));
        return stringBuffer.toString();
    }

    private String fold(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n + string.length() > 75) {
            int n2 = n;
            for (int i = 0; i < string.length(); ++i) {
                stringBuffer.append(string.charAt(i));
                if (++n2 != 75) continue;
                n2 = 0;
                stringBuffer.append("\r\n\t");
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

