/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.ListIterator;
import net.wimpi.pim.contact.basicimpl.ContactImpl;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandlerManager;
import net.wimpi.pim.contact.io.vcard.vCardMarshaller;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.versitio.versitException;
import net.wimpi.pim.util.versitio.versitItem;
import net.wimpi.pim.util.versitio.versitParser;

public class vCardUnmarshaller
implements ContactUnmarshaller {
    private String m_Encoding = null;
    private ItemHandlerManager m_ItemHandlerManager = ItemHandlerManager.getReference();
    private boolean m_Strict = true;

    public vCardUnmarshaller() {
    }

    public vCardUnmarshaller(String string) {
        this.m_Encoding = string;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public void setEncoding(String string) {
        this.m_Encoding = string;
    }

    public Contact unmarshallContact(InputStream inputStream) {
        return this.unmarshallContacts(inputStream)[0];
    }

    public Contact[] unmarshallContacts(InputStream inputStream) {
        Contact[] contactArray = null;
        try {
            List list = this.parseStream(inputStream);
            contactArray = new Contact[list.size()];
            int n = 0;
            for (List list2 : list) {
                contactArray[n] = this.processCard(list2);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return contactArray;
    }

    public void setStrict(boolean bl) {
        this.m_Strict = bl;
    }

    public boolean isStrict() {
        return this.m_Strict;
    }

    private List parseStream(InputStream inputStream) throws versitException {
        versitParser versitParser2 = null;
        if (this.m_Encoding == null) {
            versitParser2 = new versitParser(inputStream);
        } else {
            try {
                versitParser2 = new versitParser(inputStream, this.m_Encoding);
                versitParser2.setValidating(this.m_Strict);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new versitException("Encoding " + this.m_Encoding + "not supported.");
            }
        }
        versitParser2.parse();
        return versitParser2.getCardObjects();
    }

    private Contact processCard(List list) {
        ContactImpl contactImpl = new ContactImpl();
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                versitItem versitItem2 = (versitItem)listIterator.next();
                this.processItem(contactImpl, versitItem2);
            }
        }
        return contactImpl;
    }

    private void processItem(Contact contact, versitItem versitItem2) {
        ItemHandler itemHandler = this.m_ItemHandlerManager.getItemHandler(versitItem2.getIdentifier());
        if (itemHandler != null) {
            itemHandler.handleItem(contact, versitItem2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(file);
            vCardUnmarshaller vCardUnmarshaller2 = new vCardUnmarshaller();
            Contact contact = vCardUnmarshaller2.unmarshallContact(fileInputStream);
            vCardMarshaller vCardMarshaller2 = new vCardMarshaller();
            vCardMarshaller2.marshallContact(System.out, contact);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

