/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class TZItemHandler
implements ItemHandler {
    TZItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        String string;
        GeographicalInformation geographicalInformation = contact.getGeographicalInformation();
        if (geographicalInformation == null) {
            geographicalInformation = Pim.getContactModelFactory().createGeographicalInformation();
            contact.setGeographicalInformation(geographicalInformation);
        }
        if (!StringUtil.isValidString(string = versitItem2.getDecodedValue())) {
            return;
        }
        String[] stringArray = this.processTZ(string);
        geographicalInformation.setTimeZone(new SimpleTimeZone(this.getOffset(stringArray), this.getStdID(stringArray)));
    }

    public versitItem[] createItems(Contact contact) {
        GeographicalInformation geographicalInformation = contact.getGeographicalInformation();
        if (geographicalInformation == null) {
            return new versitItem[0];
        }
        TimeZone timeZone = geographicalInformation.getTimeZone();
        if (timeZone == null) {
            return new versitItem[0];
        }
        String string = timeZone.getID();
        timeZone.setID("none");
        String string2 = timeZone.getDisplayName();
        timeZone.setID(string);
        if (!StringUtil.isValidString(string2)) {
            return new versitItem[0];
        }
        versitItem[] versitItemArray = new versitItem[1];
        versitItem versitItem2 = new versitItem("TZ");
        versitItem2.setValue(string2.substring(3, string2.length()));
        versitItemArray[0] = versitItem2;
        return versitItemArray;
    }

    private int getOffset(String[] stringArray) {
        int n = 0;
        try {
            n = 60 * Integer.parseInt(stringArray[1]);
            n += Integer.parseInt(stringArray[2]);
            if (stringArray[0].equals("-")) {
                n = -1 * n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        n = n * 60 * 1000;
        return n;
    }

    private String getStdID(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        stringBuffer.append(stringArray[1]);
        if (stringArray[2] != null && stringArray[2].length() > 0) {
            stringBuffer.append(":").append(stringArray[2]);
        }
        return stringBuffer.toString();
    }

    private String[] processTZ(String string) {
        String[] stringArray = new String[3];
        stringArray[0] = string.substring(0, 1);
        int n = string.indexOf(58);
        if (n > 0) {
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            stringArray[1] = string.substring(1, 3);
            stringArray[2] = string.substring(4, 6);
        } else {
            if (string.length() > 5) {
                string = string.substring(0, 6);
            }
            stringArray[1] = string.substring(1, 3);
            stringArray[2] = string.length() > 3 ? string.substring(3, 5) : "";
        }
        return stringArray;
    }
}

