/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Sound;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class SOUNDItemHandler
implements ItemHandler {
    SOUNDItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        Sound sound = Pim.getContactModelFactory().createSound();
        String[] stringArray = null;
        stringArray = versitItem2.getParameter("VALUE");
        if (stringArray != null && (stringArray[0].equalsIgnoreCase("URL") || stringArray[0].equalsIgnoreCase("URI"))) {
            sound.setURI(versitItem2.getDecodedValue());
        } else {
            stringArray = versitItem2.getParameter("ENCODING");
            if (stringArray != null && (stringArray[0].equalsIgnoreCase("B") || stringArray[0].equalsIgnoreCase("BASE64"))) {
                sound.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(versitItem2.getValue().getBytes())));
            }
            if ((stringArray = versitItem2.getParameter("TYPE")) == null) {
                stringArray = versitItem2.getParameter("DEFAULT");
            }
            if (stringArray != null) {
                sound.setContentType("audio/" + stringArray[0].toLowerCase());
            }
        }
        contact.setSound(sound);
    }

    public versitItem[] createItems(Contact contact) {
        if (!contact.hasSound()) {
            return new versitItem[0];
        }
        versitItem[] versitItemArray = new versitItem[1];
        Sound sound = contact.getSound();
        versitItem versitItem2 = new versitItem("SOUND");
        if (sound.isURI()) {
            versitItem2.addParameter("VALUE", "URI");
            versitItem2.setValue(sound.getURI());
        } else {
            String string = sound.getContentType();
            string = string.substring(string.indexOf("/") + 1, string.length()).toUpperCase();
            versitItem2.addParameter("ENCODING", "B");
            versitItem2.addParameter("TYPE", string);
            versitItem2.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(sound.getData()))));
        }
        versitItemArray[0] = versitItem2;
        return versitItemArray;
    }
}

