/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class PHOTOItemHandler
implements ItemHandler {
    PHOTOItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        Image image = Pim.getContactModelFactory().createImage();
        String[] stringArray = null;
        stringArray = versitItem2.getParameter("VALUE");
        if (stringArray != null && (stringArray[0].equalsIgnoreCase("URL") || stringArray[0].equalsIgnoreCase("URI"))) {
            image.setURI(versitItem2.getDecodedValue());
        } else {
            stringArray = versitItem2.getParameter("ENCODING");
            if (stringArray != null && (stringArray[0].equalsIgnoreCase("B") || stringArray[0].equalsIgnoreCase("BASE64"))) {
                image.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(versitItem2.getValue().getBytes())));
            }
            if ((stringArray = versitItem2.getParameter("TYPE")) == null) {
                stringArray = versitItem2.getParameter("DEFAULT");
            }
            if (stringArray != null) {
                image.setContentType("image/" + stringArray[0].toLowerCase());
            }
        }
        PersonalIdentity personalIdentity = contact.getPersonalIdentity();
        if (personalIdentity == null) {
            personalIdentity = Pim.getContactModelFactory().createPersonalIdentity();
            contact.setPersonalIdentity(personalIdentity);
        }
        personalIdentity.setPhoto(image);
    }

    public versitItem[] createItems(Contact contact) {
        if (!contact.hasPersonalIdentity()) {
            return new versitItem[0];
        }
        if (!contact.getPersonalIdentity().hasPhoto()) {
            return new versitItem[0];
        }
        versitItem[] versitItemArray = new versitItem[1];
        Image image = contact.getPersonalIdentity().getPhoto();
        if (image == null) {
            return new versitItem[0];
        }
        versitItem versitItem2 = new versitItem("PHOTO");
        if (image.isURI()) {
            versitItem2.addParameter("VALUE", "URI");
            versitItem2.setValue(image.getURI());
        } else {
            String string = image.getContentType();
            string = string.substring(string.indexOf("/") + 1, string.length()).toUpperCase();
            versitItem2.addParameter("ENCODING", "B");
            versitItem2.addParameter("TYPE", string);
            versitItem2.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(image.getData()))));
        }
        versitItemArray[0] = versitItem2;
        return versitItemArray;
    }
}

