/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class ORGItemHandler
implements ItemHandler {
    ORGItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        Organization organization;
        OrganizationalIdentity organizationalIdentity = contact.getOrganizationalIdentity();
        if (organizationalIdentity == null) {
            organizationalIdentity = Pim.getContactModelFactory().createOrganizationalIdentity();
            contact.setOrganizationalIdentity(organizationalIdentity);
        }
        if ((organization = organizationalIdentity.getOrganization()) == null) {
            organization = Pim.getContactModelFactory().createOrganization();
            organizationalIdentity.setOrganization(organization);
        }
        String[] stringArray = StringUtil.split(versitItem2.getDecodedValue(), ";");
        block3: for (int i = 0; i < stringArray.length; ++i) {
            switch (i) {
                case 0: {
                    organization.setName(stringArray[0]);
                    continue block3;
                }
                default: {
                    if (stringArray[i].length() <= 0) continue block3;
                    organization.addUnit(stringArray[i]);
                }
            }
        }
    }

    public versitItem[] createItems(Contact contact) {
        OrganizationalIdentity organizationalIdentity = contact.getOrganizationalIdentity();
        if (organizationalIdentity == null) {
            return new versitItem[0];
        }
        versitItem[] versitItemArray = new versitItem[1];
        Organization organization = organizationalIdentity.getOrganization();
        if (organization == null) {
            return new versitItem[0];
        }
        String string = organization.getName();
        String[] stringArray = organization.listUnits();
        if (!StringUtil.isValidString(string)) {
            return new versitItem[0];
        }
        versitItem versitItem2 = new versitItem("ORG");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(organization.getName()).append(";");
        if (StringUtil.isValidStringArray(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(";");
            }
        } else {
            stringBuffer.append(";");
        }
        versitItem2.setValue(stringBuffer.toString());
        versitItemArray[0] = versitItem2;
        return versitItemArray;
    }
}

