/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class LABELItemHandler
implements ItemHandler {
    LABELItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        String string = versitItem2.getDecodedValue();
        Address address = contact.getLastAddedAddress();
        if (address == null) {
            return;
        }
        address.setLabel(string);
    }

    public versitItem[] createItems(Contact contact) {
        versitItem[] versitItemArray = new versitItem[contact.getAddressCount()];
        int n = 0;
        Iterator iterator = contact.getAddresses();
        while (iterator.hasNext()) {
            Address address = (Address)iterator.next();
            if (address == null) {
                return new versitItem[0];
            }
            String string = address.getLabel();
            if (!StringUtil.isValidString(string)) {
                return new versitItem[0];
            }
            versitItem versitItem2 = new versitItem("LABEL");
            if (address.isDomestic()) {
                versitItem2.addParameter("TYPE", "DOM");
            }
            if (address.isInternational()) {
                versitItem2.addParameter("TYPE", "INTL");
            }
            if (address.isPostal()) {
                versitItem2.addParameter("TYPE", "POSTAL");
            }
            if (address.isParcel()) {
                versitItem2.addParameter("TYPE", "PARCEL");
            }
            if (address.isHome()) {
                versitItem2.addParameter("TYPE", "HOME");
            }
            if (address.isWork()) {
                versitItem2.addParameter("TYPE", "WORK");
            }
            if (contact.isPreferredAddress(address)) {
                versitItem2.addParameter("TYPE", "PREF");
            }
            versitItem2.setValue(new String(EncodingUtility.encodeLineBreaks(string.getBytes())));
            versitItemArray[n] = versitItem2;
            ++n;
        }
        return versitItemArray;
    }
}

