/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class EMAILItemHandler
implements ItemHandler {
    EMAILItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        boolean bl = false;
        EmailAddress emailAddress = Pim.getContactModelFactory().createEmailAddress();
        emailAddress.setAddress(versitItem2.getDecodedValue());
        String[] stringArray = versitItem2.getParameter("TYPE");
        if (stringArray == null) {
            stringArray = versitItem2.getParameter("DEFAULT");
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("PREF")) {
                    bl = true;
                    continue;
                }
                emailAddress.setType(stringArray[i]);
            }
        } else {
            emailAddress.setType("INTERNET");
        }
        Communications communications = contact.getCommunications();
        if (communications == null) {
            communications = Pim.getContactModelFactory().createCommunications();
            contact.setCommunications(communications);
        }
        communications.addEmailAddress(emailAddress);
        if (bl) {
            communications.setPreferredEmailAddress(emailAddress);
        }
    }

    public versitItem[] createItems(Contact contact) {
        if (!contact.hasCommunications()) {
            return new versitItem[0];
        }
        Communications communications = contact.getCommunications();
        versitItem[] versitItemArray = new versitItem[communications.getEmailAddressCount()];
        int n = 0;
        Iterator iterator = communications.getEmailAddresses();
        while (iterator.hasNext()) {
            EmailAddress emailAddress = (EmailAddress)iterator.next();
            String string = emailAddress.getAddress();
            String string2 = emailAddress.getType();
            if (!StringUtil.isValidString(string)) {
                return null;
            }
            versitItem versitItem2 = new versitItem("EMAIL");
            versitItem2.setValue(string);
            if (communications.isPreferredEmailAddress(emailAddress)) {
                versitItem2.addParameter("TYPE", "PREF");
            }
            if (StringUtil.isValidString(string2)) {
                versitItem2.addParameter("TYPE", string2);
            }
            versitItemArray[n] = versitItem2;
            ++n;
        }
        return versitItemArray;
    }
}

