/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class BDAYItemHandler
implements ItemHandler {
    private DateFormat m_SimpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    private DateFormat m_ExtendedDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void handleItem(Contact contact, versitItem versitItem2) {
        String string = versitItem2.getDecodedValue();
        Date date = null;
        string = StringUtil.split(string, "T")[0];
        try {
            date = string.indexOf("-") == -1 ? this.m_SimpleDateFormat.parse(string) : this.m_ExtendedDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        PersonalIdentity personalIdentity = contact.getPersonalIdentity();
        if (personalIdentity == null) {
            personalIdentity = Pim.getContactModelFactory().createPersonalIdentity();
            contact.setPersonalIdentity(personalIdentity);
        }
        personalIdentity.setBirthDate(date);
    }

    public versitItem[] createItems(Contact contact) {
        PersonalIdentity personalIdentity = contact.getPersonalIdentity();
        if (personalIdentity == null) {
            return new versitItem[0];
        }
        versitItem[] versitItemArray = new versitItem[1];
        Date date = personalIdentity.getBirthDate();
        if (date == null) {
            return new versitItem[0];
        }
        versitItem versitItem2 = new versitItem("BDAY");
        versitItem2.setValue(this.m_ExtendedDateFormat.format(date));
        versitItemArray[0] = versitItem2;
        return versitItemArray;
    }
}

