/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.facades;

import java.util.Date;
import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.contact.model.PhoneNumber;
import net.wimpi.pim.factory.ContactModelFactory;
import net.wimpi.pim.util.Identifiable;

public class SimpleContact {
    private transient ContactModelFactory m_CFM = Pim.getContactModelFactory();
    private transient Contact m_Contact;
    private transient PersonalIdentity m_PID;
    private transient OrganizationalIdentity m_OID;
    private transient Organization m_Org;
    private transient Communications m_COMM;
    private transient PhoneNumber m_HomeNumber;
    private transient PhoneNumber m_WorkNumber;
    private transient PhoneNumber m_PagerNumber;
    private transient PhoneNumber m_MobileNumber;
    private transient PhoneNumber m_FaxNumber;
    private transient Address m_WorkAddress;
    private transient Address m_HomeAddress;
    private transient EmailAddress m_Email;
    private static final String EMPTY = "";

    public SimpleContact() {
        this.m_Contact = this.m_CFM.createContact();
    }

    public SimpleContact(Contact contact) {
        Identifiable identifiable;
        Iterator iterator;
        this.m_Contact = contact;
        if (contact.hasPersonalIdentity()) {
            this.m_PID = contact.getPersonalIdentity();
        }
        if (contact.hasOrganizationalIdentity()) {
            this.m_OID = contact.getOrganizationalIdentity();
            if (this.m_OID.hasOrganization()) {
                this.m_Org = this.m_OID.getOrganization();
            }
        }
        if (contact.hasCommunications()) {
            this.m_COMM = contact.getCommunications();
            iterator = this.m_COMM.getPhoneNumbers();
            while (iterator.hasNext()) {
                identifiable = (PhoneNumber)iterator.next();
                if (identifiable.isHome()) {
                    this.m_HomeNumber = identifiable;
                    continue;
                }
                if (identifiable.isWork()) {
                    this.m_WorkNumber = identifiable;
                    continue;
                }
                if (identifiable.isPager()) {
                    this.m_PagerNumber = identifiable;
                    continue;
                }
                if (identifiable.isFax()) {
                    this.m_FaxNumber = identifiable;
                    continue;
                }
                if (!identifiable.isCellular()) continue;
                this.m_MobileNumber = identifiable;
            }
            if (this.m_COMM.getEmailAddressCount() > 0) {
                this.m_Email = this.m_COMM.getPreferredEmailAddress();
                if (this.m_Email == null) {
                    this.m_Email = this.m_COMM.listEmailAddresses()[0];
                }
            }
        }
        iterator = this.m_Contact.getAddresses();
        while (iterator.hasNext()) {
            identifiable = (Address)iterator.next();
            if (identifiable.isHome()) {
                this.m_HomeAddress = identifiable;
                continue;
            }
            if (!identifiable.isWork()) continue;
            this.m_WorkAddress = identifiable;
        }
    }

    public String getUID() {
        return this.m_Contact.getUID();
    }

    public String getCategory() {
        try {
            return this.m_Contact.getCategory(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return EMPTY;
        }
    }

    public void setCategory(String string) {
        this.m_Contact.removeAllCategories();
        if (string != null && string.length() > 0) {
            this.m_Contact.addCategory(string);
        }
    }

    public String getNickname() {
        if (this.m_PID != null && this.m_PID.getNicknameCount() > 0) {
            return this.m_PID.getNickname(0);
        }
        return EMPTY;
    }

    public void setNickname(String string) {
        if (string != null && string.length() > 0) {
            this.lazyCreatePID();
            this.m_PID.removeAllNicknames();
            this.m_PID.addNickname(string);
        } else if (this.m_PID != null) {
            this.m_PID.removeAllNicknames();
        }
    }

    public String getFirstname() {
        if (this.m_PID != null) {
            return this.m_PID.getFirstname();
        }
        return EMPTY;
    }

    public void setFirstname(String string) {
        this.lazyCreatePID();
        this.m_PID.setFirstname(string);
    }

    public String getLastname() {
        if (this.m_PID != null) {
            return this.m_PID.getLastname();
        }
        return EMPTY;
    }

    public void setLastname(String string) {
        this.lazyCreatePID();
        this.m_PID.setLastname(string);
    }

    public String getMiddlename() {
        if (this.m_PID != null && this.m_PID.getNicknameCount() > 0) {
            return this.m_PID.getAdditionalName(0);
        }
        return EMPTY;
    }

    public void setMiddlename(String string) {
        if (string != null && string.length() > 0) {
            this.lazyCreatePID();
            this.m_PID.removeAllAdditionalNames();
            this.m_PID.addAdditionalName(string);
        } else if (this.m_PID != null) {
            this.m_PID.removeAllAdditionalNames();
        }
    }

    public String getCompany() {
        if (this.m_Org != null) {
            return this.m_Org.getName();
        }
        return EMPTY;
    }

    public void setCompany(String string) {
        this.lazyCreateOrg();
        this.m_Org.setName(string);
    }

    public String getTitle() {
        if (this.m_OID != null) {
            return this.m_OID.getTitle();
        }
        return EMPTY;
    }

    public void setTitle(String string) {
        this.lazyCreateOID();
        this.m_OID.setTitle(string);
    }

    public String getRole() {
        if (this.m_OID != null) {
            return this.m_OID.getRole();
        }
        return EMPTY;
    }

    public void setRole(String string) {
        this.lazyCreateOID();
        this.m_OID.setRole(string);
    }

    public String getHomePhoneNumber() {
        if (this.m_HomeNumber != null) {
            return this.m_HomeNumber.getNumber();
        }
        return EMPTY;
    }

    public void setHomePhoneNumber(String string) {
        this.lazyCreateHomeNumber();
        this.m_HomeNumber.setNumber(string);
    }

    public String getWorkPhoneNumber() {
        if (this.m_WorkNumber != null) {
            return this.m_WorkNumber.getNumber();
        }
        return EMPTY;
    }

    public void setWorkPhoneNumber(String string) {
        this.lazyCreateWorkNumber();
        this.m_WorkNumber.setNumber(string);
    }

    public String getPagerNumber() {
        if (this.m_PagerNumber != null) {
            return this.m_PagerNumber.getNumber();
        }
        return EMPTY;
    }

    public void setPagerNumber(String string) {
        this.lazyCreatePagerNumber();
        this.m_PagerNumber.setNumber(string);
    }

    public String getFaxNumber() {
        if (this.m_FaxNumber != null) {
            return this.m_FaxNumber.getNumber();
        }
        return EMPTY;
    }

    public void setFaxNumber(String string) {
        this.lazyCreateFaxNumber();
        this.m_FaxNumber.setNumber(string);
    }

    public String getMobileNumber() {
        if (this.m_MobileNumber != null) {
            return this.m_MobileNumber.getNumber();
        }
        return EMPTY;
    }

    public void setMobileNumber(String string) {
        this.lazyCreateMobileNumber();
        this.m_MobileNumber.setNumber(string);
    }

    public String getWorkStreet() {
        if (this.m_WorkAddress != null) {
            return this.m_WorkAddress.getStreet();
        }
        return EMPTY;
    }

    public void setWorkStreet(String string) {
        this.lazyCreateWorkAddress();
        this.m_WorkAddress.setStreet(string);
    }

    public String getWorkCity() {
        if (this.m_WorkAddress != null) {
            return this.m_WorkAddress.getCity();
        }
        return EMPTY;
    }

    public void setWorkCity(String string) {
        this.lazyCreateWorkAddress();
        this.m_WorkAddress.setCity(string);
    }

    public String getWorkRegion() {
        if (this.m_WorkAddress != null) {
            return this.m_WorkAddress.getRegion();
        }
        return EMPTY;
    }

    public void setWorkRegion(String string) {
        this.lazyCreateWorkAddress();
        this.m_WorkAddress.setRegion(string);
    }

    public String getWorkCountry() {
        if (this.m_WorkAddress != null) {
            return this.m_WorkAddress.getCountry();
        }
        return EMPTY;
    }

    public void setWorkCountry(String string) {
        this.lazyCreateWorkAddress();
        this.m_WorkAddress.setCountry(string);
    }

    public String getWorkZIP() {
        if (this.m_WorkAddress != null) {
            return this.m_WorkAddress.getPostalCode();
        }
        return EMPTY;
    }

    public void setWorkZIP(String string) {
        this.lazyCreateWorkAddress();
        this.m_WorkAddress.setPostalCode(string);
    }

    public String getHomeStreet() {
        if (this.m_HomeAddress != null) {
            return this.m_HomeAddress.getStreet();
        }
        return EMPTY;
    }

    public void setHomeStreet(String string) {
        this.lazyCreateHomeAddress();
        this.m_HomeAddress.setStreet(string);
    }

    public String getHomeCity() {
        if (this.m_HomeAddress != null) {
            return this.m_HomeAddress.getCity();
        }
        return EMPTY;
    }

    public void setHomeCity(String string) {
        this.lazyCreateHomeAddress();
        this.m_HomeAddress.setCity(string);
    }

    public String getHomeRegion() {
        if (this.m_HomeAddress != null) {
            return this.m_HomeAddress.getRegion();
        }
        return EMPTY;
    }

    public void setHomeRegion(String string) {
        this.lazyCreateHomeAddress();
        this.m_HomeAddress.setRegion(string);
    }

    public String getHomeCountry() {
        if (this.m_HomeAddress != null) {
            return this.m_HomeAddress.getCountry();
        }
        return EMPTY;
    }

    public void setHomeCountry(String string) {
        this.lazyCreateHomeAddress();
        this.m_HomeAddress.setCountry(string);
    }

    public String getHomeZIP() {
        if (this.m_HomeAddress != null) {
            return this.m_HomeAddress.getPostalCode();
        }
        return EMPTY;
    }

    public void setHomeZIP(String string) {
        this.lazyCreateHomeAddress();
        this.m_HomeAddress.setPostalCode(string);
    }

    public String getEmail() {
        if (this.m_Email != null) {
            return this.m_Email.getAddress();
        }
        return EMPTY;
    }

    public String getFullEmail() {
        if (this.m_Email == null || this.m_Email.getAddress() == null || this.m_Email.getAddress().length() == 0) {
            return EMPTY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_PID != null) {
            stringBuffer.append(this.m_PID.getFirstname()).append(' ').append(this.m_PID.getLastname()).append(' ');
        }
        stringBuffer.append('<').append(this.m_Email.getAddress()).append('>');
        return stringBuffer.toString();
    }

    public void setEmail(String string) {
        this.lazyCreateEmail();
        this.m_Email.setAddress(string);
    }

    public String getURL() {
        return this.m_Contact.getURL();
    }

    public void setURL(String string) {
        this.m_Contact.setURL(string);
    }

    public String getCompanyURL() {
        if (this.m_Org != null) {
            return this.m_Org.getURL();
        }
        return EMPTY;
    }

    public void setCompanyURL(String string) {
        this.lazyCreateOrg();
        this.m_Org.setURL(string);
    }

    public String getComments() {
        return this.m_Contact.getNote() != null ? this.m_Contact.getNote() : EMPTY;
    }

    public void setComments(String string) {
        if (string == null) {
            string = EMPTY;
        }
        this.m_Contact.setNote(string);
    }

    public Date getBirthDate() {
        if (this.m_PID != null) {
            return this.m_PID.getBirthDate();
        }
        return null;
    }

    public void setBirthDate(Date date) {
        if (date != null) {
            this.lazyCreatePID();
            this.m_PID.setBirthDate(date);
        }
    }

    public boolean isFrequentRecipient() {
        return this.m_Contact.isFrequent();
    }

    public void setFrequentRecipient(boolean bl) {
        this.m_Contact.setFrequent(bl);
    }

    public Contact getContact() {
        return this.m_Contact;
    }

    public boolean equals(Object object) {
        return this.m_Contact.equals(object);
    }

    private final void lazyCreatePID() {
        if (this.m_PID == null) {
            this.m_PID = this.m_CFM.createPersonalIdentity();
            this.m_Contact.setPersonalIdentity(this.m_PID);
        }
    }

    private final void lazyCreateOID() {
        if (this.m_OID == null) {
            this.m_OID = this.m_CFM.createOrganizationalIdentity();
            this.m_Contact.setOrganizationalIdentity(this.m_OID);
        }
    }

    private final void lazyCreateOrg() {
        if (this.m_Org == null) {
            this.lazyCreateOID();
            this.m_Org = this.m_CFM.createOrganization();
            this.m_OID.setOrganization(this.m_Org);
        }
    }

    private final void lazyCreateCOMM() {
        if (this.m_COMM == null) {
            this.m_COMM = this.m_CFM.createCommunications();
            this.m_Contact.setCommunications(this.m_COMM);
        }
    }

    private final void lazyCreateHomeNumber() {
        if (this.m_HomeNumber == null) {
            this.lazyCreateCOMM();
            this.m_HomeNumber = this.m_CFM.createPhoneNumber();
            this.m_HomeNumber.setHome(true);
            this.m_COMM.addPhoneNumber(this.m_HomeNumber);
        }
    }

    private final void lazyCreateWorkNumber() {
        if (this.m_WorkNumber == null) {
            this.lazyCreateCOMM();
            this.m_WorkNumber = this.m_CFM.createPhoneNumber();
            this.m_WorkNumber.setHome(false);
            this.m_WorkNumber.setWork(true);
            this.m_COMM.addPhoneNumber(this.m_WorkNumber);
        }
    }

    private final void lazyCreatePagerNumber() {
        if (this.m_PagerNumber == null) {
            this.lazyCreateCOMM();
            this.m_PagerNumber = this.m_CFM.createPhoneNumber();
            this.m_PagerNumber.setPager(true);
            this.m_COMM.addPhoneNumber(this.m_PagerNumber);
        }
    }

    private final void lazyCreateFaxNumber() {
        if (this.m_FaxNumber == null) {
            this.lazyCreateCOMM();
            this.m_FaxNumber = this.m_CFM.createPhoneNumber();
            this.m_FaxNumber.setFax(true);
            this.m_COMM.addPhoneNumber(this.m_FaxNumber);
        }
    }

    private final void lazyCreateMobileNumber() {
        if (this.m_MobileNumber == null) {
            this.lazyCreateCOMM();
            this.m_MobileNumber = this.m_CFM.createPhoneNumber();
            this.m_MobileNumber.setCellular(true);
            this.m_COMM.addPhoneNumber(this.m_MobileNumber);
        }
    }

    private final void lazyCreateWorkAddress() {
        if (this.m_WorkAddress == null) {
            this.m_WorkAddress = this.m_CFM.createAddress();
            this.m_WorkAddress.setWork(true);
            this.m_Contact.addAddress(this.m_WorkAddress);
        }
    }

    private final void lazyCreateHomeAddress() {
        if (this.m_HomeAddress == null) {
            this.m_HomeAddress = this.m_CFM.createAddress();
            this.m_HomeAddress.setHome(true);
            this.m_Contact.addAddress(this.m_HomeAddress);
        }
    }

    private final void lazyCreateEmail() {
        if (this.m_Email == null) {
            this.lazyCreateCOMM();
            this.m_Email = this.m_CFM.createEmailAddress();
            this.m_COMM.addEmailAddress(this.m_Email);
            this.m_COMM.setPreferredEmailAddress(this.m_Email);
        }
    }
}

