/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.db.serializable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.wimpi.pim.contact.db.ContactGroup;
import net.wimpi.pim.contact.db.ContactGroupCollection;
import net.wimpi.pim.contact.db.ContactGroupFilter;

public class ContactGroupCollectionImpl
implements ContactGroupCollection,
Serializable {
    static final long serialVersionUID = 7926133701871079538L;
    protected Map m_Groups = new HashMap(50);
    protected Map m_NameIndex = new HashMap(50);
    protected transient int m_ModCount = 0;

    public boolean contains(String string) {
        return this.m_Groups.keySet().contains(string);
    }

    public boolean contains(ContactGroup contactGroup) {
        return this.contains(contactGroup.getUID());
    }

    public boolean containsByName(String string) {
        return this.m_NameIndex.keySet().contains(string);
    }

    public ContactGroup get(String string) {
        return (ContactGroup)this.m_Groups.get(string);
    }

    public ContactGroup getByName(String string) {
        return this.get((String)this.m_NameIndex.get(string));
    }

    public ContactGroup[] toArray() {
        ContactGroup[] contactGroupArray = new ContactGroup[this.m_Groups.size()];
        Iterator iterator = this.iterator();
        for (int i = 0; i < this.m_Groups.size(); ++i) {
            contactGroupArray[i] = (ContactGroup)iterator.next();
        }
        return contactGroupArray;
    }

    public ContactGroup[] toArray(ContactGroupFilter contactGroupFilter) {
        GroupIterator groupIterator = new GroupIterator(contactGroupFilter);
        ContactGroup[] contactGroupArray = new ContactGroup[groupIterator.size()];
        for (int i = 0; i < groupIterator.size(); ++i) {
            contactGroupArray[i] = (ContactGroup)groupIterator.next();
        }
        return contactGroupArray;
    }

    public boolean add(ContactGroup contactGroup) {
        if (this.containsByName(contactGroup.getName())) {
            return false;
        }
        int n = this.size();
        this.m_Groups.put(contactGroup.getUID(), contactGroup);
        this.addToNameIndex(contactGroup);
        if (n != this.size()) {
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return true;
    }

    public ContactGroup remove(String string) {
        ContactGroup contactGroup = (ContactGroup)this.m_Groups.remove(string);
        if (contactGroup != null) {
            this.removeFromNameIndex(contactGroup);
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return contactGroup;
    }

    public void remove(ContactGroup contactGroup) {
        this.remove(contactGroup.getUID());
    }

    public Iterator iterator() {
        return new GroupIterator();
    }

    public Iterator iterator(ContactGroupFilter contactGroupFilter) {
        return new GroupIterator(contactGroupFilter);
    }

    public int size() {
        return this.m_Groups.size();
    }

    private void addToNameIndex(ContactGroup contactGroup) {
        if (contactGroup == null) {
            return;
        }
        String string = contactGroup.getName();
        if (string != null && string.length() > 0) {
            this.m_NameIndex.put(string, contactGroup.getUID());
        }
    }

    private void removeFromNameIndex(ContactGroup contactGroup) {
        if (contactGroup == null) {
            return;
        }
        String string = contactGroup.getName();
        if (string != null && string.length() > 0) {
            this.m_NameIndex.remove(string);
        }
    }

    private boolean modified(int n) {
        return n != this.m_ModCount;
    }

    class GroupIterator
    implements Iterator {
        private ArrayList m_Entries;
        private int m_Next;
        private int m_Last = -1;
        private int m_ExpectedModCount;

        public GroupIterator() {
            this.m_ExpectedModCount = ContactGroupCollectionImpl.this.m_ModCount;
            this.prepare(null);
        }

        public GroupIterator(ContactGroupFilter contactGroupFilter) {
            this.m_ExpectedModCount = ContactGroupCollectionImpl.this.m_ModCount;
            this.prepare(contactGroupFilter);
        }

        private void prepare(ContactGroupFilter contactGroupFilter) {
            int n = ContactGroupCollectionImpl.this.size();
            this.m_Entries = new ArrayList(n);
            Iterator iterator = ContactGroupCollectionImpl.this.m_Groups.values().iterator();
            for (int i = 0; i < n; ++i) {
                ContactGroup contactGroup = (ContactGroup)iterator.next();
                if (contactGroupFilter != null) {
                    if (!contactGroupFilter.passes(contactGroup)) continue;
                    this.m_Entries.add(contactGroup);
                    continue;
                }
                this.m_Entries.add(contactGroup);
            }
            this.m_Next = 0;
        }

        public boolean hasNext() {
            return this.m_Next < this.m_Entries.size();
        }

        public Object next() {
            if (this.m_Next >= this.m_Entries.size()) {
                throw new NoSuchElementException();
            }
            if (ContactGroupCollectionImpl.this.modified(this.m_ExpectedModCount)) {
                throw new ConcurrentModificationException();
            }
            Object e = this.m_Entries.get(this.m_Next);
            this.m_Last = this.m_Next++;
            return e;
        }

        public void remove() {
            if (this.m_Last == -1) {
                throw new IllegalStateException();
            }
            ContactGroupCollectionImpl.this.remove((ContactGroup)this.m_Entries.get(this.m_Last));
            this.m_Entries.remove(this.m_Last);
            this.m_Last = -1;
            --this.m_Next;
            ++this.m_ExpectedModCount;
        }

        public int size() {
            return this.m_Entries.size();
        }
    }
}

