/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Extensions;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.contact.model.Key;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.contact.model.Sound;
import net.wimpi.pim.util.AbstractIdentifiable;
import net.wimpi.pim.util.StringUtil;

public class ContactImpl
extends AbstractIdentifiable
implements Contact {
    static final long serialVersionUID = 5552536829541983668L;
    protected String m_Url;
    protected boolean m_Frequent = false;
    protected String m_Note;
    protected Date m_Revision;
    protected String m_Classification;
    protected List m_Addresses = Collections.synchronizedList(new ArrayList(5));
    protected List m_Categories = Collections.synchronizedList(new ArrayList(5));
    protected Address m_PreferredAddress;
    protected Address m_LastAddedAddress;
    protected PersonalIdentity m_PersonalIdentity;
    protected OrganizationalIdentity m_OrganizationalIdentity;
    protected Communications m_Communications;
    protected GeographicalInformation m_GeoInfo;
    protected Key m_Key;
    protected Sound m_Sound;
    protected Extensions m_Extensions;

    public PersonalIdentity getPersonalIdentity() {
        return this.m_PersonalIdentity;
    }

    public void setPersonalIdentity(PersonalIdentity personalIdentity) {
        this.m_PersonalIdentity = personalIdentity;
    }

    public boolean hasPersonalIdentity() {
        return this.m_PersonalIdentity != null;
    }

    public OrganizationalIdentity getOrganizationalIdentity() {
        return this.m_OrganizationalIdentity;
    }

    public void setOrganizationalIdentity(OrganizationalIdentity organizationalIdentity) {
        this.m_OrganizationalIdentity = organizationalIdentity;
    }

    public boolean hasOrganizationalIdentity() {
        return this.m_OrganizationalIdentity != null;
    }

    public Iterator getAddresses() {
        return this.m_Addresses.listIterator();
    }

    public Address[] listAddresses() {
        Address[] addressArray = new Address[this.m_Addresses.size()];
        return this.m_Addresses.toArray(addressArray);
    }

    public Address getAddress(String string) {
        for (Address address : this.m_Addresses) {
            if (!address.equals(string)) continue;
            return address;
        }
        return null;
    }

    public Address getLastAddedAddress() {
        return this.m_LastAddedAddress;
    }

    public void addAddress(Address address) {
        this.m_Addresses.add(address);
        this.m_LastAddedAddress = address;
    }

    public void removeAddress(Address address) throws IndexOutOfBoundsException {
        if (this.isPreferredAddress(address)) {
            this.m_PreferredAddress = null;
        }
        this.m_Addresses.remove(address);
    }

    public Address getPreferredAddress() {
        return this.m_PreferredAddress;
    }

    public void setPreferredAddress(Address address) {
        if (this.m_Addresses.contains(address)) {
            this.m_PreferredAddress = address;
        }
    }

    public boolean isPreferredAddress(Address address) {
        return address.equals(this.m_PreferredAddress);
    }

    public int getAddressCount() {
        return this.m_Addresses.size();
    }

    public Address[] listAddressesByType(int n) {
        ArrayList<Address> arrayList = new ArrayList<Address>(this.m_Addresses.size());
        for (Address address : this.m_Addresses) {
            if (!address.isType(n)) continue;
            arrayList.add(address);
        }
        Address[] addressArray = new Address[arrayList.size()];
        return arrayList.toArray(addressArray);
    }

    public Communications getCommunications() {
        return this.m_Communications;
    }

    public void setCommunications(Communications communications) {
        this.m_Communications = communications;
    }

    public boolean hasCommunications() {
        return this.m_Communications != null;
    }

    public GeographicalInformation getGeographicalInformation() {
        return this.m_GeoInfo;
    }

    public void setGeographicalInformation(GeographicalInformation geographicalInformation) {
        this.m_GeoInfo = geographicalInformation;
    }

    public boolean hasGeographicalInformation() {
        return this.m_GeoInfo != null;
    }

    public String getCategoriesList() {
        return StringUtil.joinList(this.listCategories());
    }

    public void setCategoriesList(String string) {
        String[] stringArray = StringUtil.splitList(string);
        this.m_Categories.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCategory(stringArray[i]);
        }
    }

    public String[] listCategories() {
        String[] stringArray = new String[this.m_Categories.size()];
        return this.m_Categories.toArray(stringArray);
    }

    public String getCategory(int n) throws IndexOutOfBoundsException {
        return (String)this.m_Categories.get(n);
    }

    public String setCategory(int n, String string) {
        return this.m_Categories.set(n, string);
    }

    public void addCategory(String string) {
        this.m_Categories.add(string);
    }

    public String removeCategory(int n) throws IndexOutOfBoundsException {
        return (String)this.m_Categories.remove(n);
    }

    public void removeAllCategories() {
        this.m_Categories.clear();
    }

    public int getCategoryCount() {
        return this.m_Categories.size();
    }

    public String getURL() {
        return this.m_Url;
    }

    public void setURL(String string) {
        this.m_Url = string;
    }

    public boolean isFrequent() {
        return this.m_Frequent;
    }

    public void setFrequent(boolean bl) {
        this.m_Frequent = bl;
    }

    public String getNote() {
        return this.m_Note;
    }

    public void setNote(String string) {
        this.m_Note = string;
    }

    public Date getCurrentRevisionDate() {
        return this.m_Revision;
    }

    public void setCurrentRevisionDate(Date date) {
        this.m_Revision = date;
    }

    public String getAccessClassification() {
        return this.m_Classification;
    }

    public void setAccessClassification(String string) {
        this.m_Classification = string;
    }

    public Key getPublicKey() {
        return this.m_Key;
    }

    public void setPublicKey(Key key) {
        this.m_Key = key;
    }

    public boolean hasPublicKey() {
        return this.m_Key != null;
    }

    public Sound getSound() {
        return this.m_Sound;
    }

    public void setSound(Sound sound) {
        this.m_Sound = sound;
    }

    public boolean hasSound() {
        return this.m_Sound != null;
    }

    public Extensions getExtensions() {
        return this.m_Extensions;
    }

    public void setExtensions(Extensions extensions) {
        this.m_Extensions = extensions;
    }

    public boolean hasExtensions() {
        return this.m_Extensions != null;
    }
}

