/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa.wrapper;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;

public class XAResourceImpl
implements XAResource {
    private Transaction trans;
    private Connection con;
    private XAConnectionExt xaCon;
    private Xid current;
    private boolean active = false;
    private int timeout_ignored = 0;
    private Logger log = Logger.getLogger(XAResourceImpl.class);

    public XAResourceImpl(Connection con) {
        this.con = con;
    }

    public void setXAConnection(XAConnectionExt xaCon, boolean force) {
        if (this.xaCon != null && !force) {
            throw new IllegalStateException();
        }
        this.xaCon = xaCon;
    }

    public void setXAConnection(XAConnectionExt xaCon) {
        this.setXAConnection(xaCon, false);
    }

    public XAConnection getXAConnection() {
        return this.xaCon;
    }

    public void setTransaction(Transaction t) {
        this.trans = t;
    }

    public Transaction getTransaction() {
        return this.trans;
    }

    public boolean isTransaction() {
        return this.current != null;
    }

    public Xid getCurrent() {
        return this.current;
    }

    public void close() {
        this.con = null;
        this.current = null;
        this.xaCon = null;
    }

    public void commit(Xid id, boolean twoPhase) throws XAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("commit: " + this.xaCon + ", current: " + this.current + ", xid: " + id + ", active: " + this.active));
        }
        if (this.active && !twoPhase) {
            this.log.warn((Object)"WARNING: Connection not closed before transaction commit.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
        }
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            try {
                this.con.rollback();
                if (!twoPhase) {
                    this.throwXAException(100);
                }
            }
            catch (SQLException e2) {
                this.log.debug((Object)e2);
            }
            if (twoPhase) {
                this.throwXAException(6);
            }
            this.throwXAException(104);
        }
        this.current = null;
        if (this.active) {
            this.active = false;
        } else {
            this.xaCon.transactionFinished();
        }
    }

    public void end(Xid id, int flags) throws XAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + this.xaCon + ", current: " + this.current + ", xid: " + id + ", active: " + this.active));
        }
        if (!this.active) {
            this.throwXAException(-6);
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        this.active = false;
    }

    public void forget(Xid id) throws XAException {
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        this.current = null;
        this.xaCon.transactionFailed();
        if (this.active) {
            this.log.warn((Object)"WARNING: Connection not closed before transaction forget.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout_ignored;
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res == this;
    }

    public int prepare(Xid id) throws XAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("prepare: " + this.xaCon + ", current: " + this.current + ", xid: " + id + ", active: " + this.active));
        }
        if (this.active) {
            this.log.warn((Object)"WARNING: Connection not closed before transaction commit.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.current == null) {
            return new Xid[0];
        }
        return new Xid[]{this.current};
    }

    public void rollback(Xid id) throws XAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("rollback: " + this.xaCon + ", current: " + this.current + ", xid: " + id + ", active: " + this.active));
        }
        if (this.active) {
            this.log.warn((Object)"WARNING: Connection not closed before transaction rollback. Connection will not participate in any future transactions. Are you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
        }
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            this.throwXAException("Rollback failed: " + e.getMessage());
        }
        this.current = null;
        if (this.active) {
            this.active = false;
        } else {
            this.xaCon.transactionFinished();
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout_ignored = timeout;
        return true;
    }

    public void start(Xid id, int flags) throws XAException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start: " + this.xaCon + ", current: " + this.current + ", xid: " + id + ", active: " + this.active));
        }
        if (this.active) {
            if (this.current != null && id.equals(this.current)) {
                this.throwXAException(-8);
            } else {
                this.throwXAException(-6);
            }
        }
        if (this.current != null && !id.equals(this.current)) {
            this.log.error((Object)("attempt to inactive start resource with existing xid; current xid: " + this.current + ", new xid: " + id));
            this.throwXAException(-4);
        }
        if (this.con == null) {
            this.log.error((Object)"no connection associated with resource");
            this.throwXAException(104);
        }
        this.current = id;
        this.active = true;
    }

    protected void throwXAException(int code) throws XAException {
        this.xaCon.setConnectionError(new SQLException("XAException occured with code: " + code));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(XAException) - SQLException code: " + code));
        }
        throw new XAException(code);
    }

    protected void throwXAException(String msg) throws XAException {
        this.xaCon.setConnectionError(new SQLException("XAException occured: " + msg));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(XAException) - SQLException msg: " + msg));
        }
        throw new XAException(msg);
    }
}

