/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa.wrapper;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionImpl;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XADataSourceImpl
implements XADataSource {
    protected String url;
    protected String user;
    protected String password;
    protected String driverName;
    protected Driver driver;
    protected Properties properties;
    protected int loginTimeout;
    protected PrintWriter logWriter;
    protected boolean saveStackTrace;
    private static Logger log = Logger.getLogger(XADataSourceImpl.class);

    public XADataSourceImpl() {
    }

    public XADataSourceImpl(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriver(String driverName) {
        this.driverName = driverName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean getSaveStackTrace() {
        return this.saveStackTrace;
    }

    public void setSaveStackTrace(boolean save) {
        this.saveStackTrace = save;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (writer == null) {
            this.logWriter = null;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.loginTimeout = timeout;
    }

    protected void loadDriver() throws SQLException {
        if (this.driver == null) {
            try {
                this.driver = (Driver)Class.forName(this.driverName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                DriverManager.registerDriver(this.driver);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("loaded and registered driver: " + this.driverName));
                }
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"unable to load driver", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.warn((Object)"unable to instantiate driver", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"illegal access exception", (Throwable)e);
            }
        }
    }

    public XAConnection getXAConnection() throws SQLException {
        this.loadDriver();
        Connection con = this.user != null && this.user.length() > 0 ? DriverManager.getConnection(this.url, this.user, this.password) : (this.properties != null ? DriverManager.getConnection(this.url, this.properties) : DriverManager.getConnection(this.url));
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.warn((Object)("Unable to disable auto-commit on " + con.getClass().getName()));
        }
        XAResourceImpl res = new XAResourceImpl(con);
        XAConnectionImpl xacon = new XAConnectionImpl(con, res, this.saveStackTrace);
        res.setXAConnection(xacon);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created new Connection(" + con.getClass().getName() + ") with XAResource " + res.getClass().getName() + " and XAConnection " + xacon.getClass().getName() + "."));
        }
        return xacon;
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        this.loadDriver();
        Connection con = DriverManager.getConnection(this.url, user, password);
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.warn((Object)("Unable to disable auto-commit on " + con.getClass().getName()));
        }
        XAResourceImpl res = new XAResourceImpl(con);
        XAConnectionImpl xacon = new XAConnectionImpl(con, res, this.saveStackTrace);
        res.setXAConnection(xacon);
        xacon.setUser(user);
        xacon.setPassword(password);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" created new Connection (" + con.getClass().getName() + ") with XAResource " + res.getClass().getName() + " and XAConnection with userid and password " + xacon.getClass().getName()));
        }
        return xacon;
    }
}

