/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa.wrapper;

import java.sql.SQLException;
import java.util.Date;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;

public class XAConnectionMonitor
implements XAResource,
ConnectionEventListener {
    private TransactionManager mgr;
    private XAConnection xaCon;
    private long monStart;
    private Xid xid;
    private int timeout;
    private boolean active = false;
    private Logger log = Logger.getLogger(XAConnectionMonitor.class);

    public XAConnectionMonitor(TransactionManager mgr, XAConnection xaCon) {
        this.xaCon = xaCon;
        this.mgr = mgr;
        this.xaCon.addConnectionEventListener(this);
    }

    public TransactionManager getTransactionManager() {
        return this.mgr;
    }

    public XAConnection getXAConnection() {
        return this.xaCon;
    }

    public void enlist() throws XAException {
        try {
            Transaction tx;
            if (this.mgr != null && this.mgr.getStatus() == 0) {
                tx = this.mgr.getTransaction();
                if (tx == null) {
                    throw new XAException(-4);
                }
            } else {
                throw new XAException("No transaction manager or invalid status");
            }
            tx.enlistResource((XAResource)this);
        }
        catch (SystemException e) {
            throw new XAException("Unable to get transaction status");
        }
        catch (RollbackException e) {
            throw new XAException("Unable to enlist resource with transaction");
        }
    }

    public void start(Xid xid, int flag) throws XAException {
        if (this.active) {
            if (this.xid != null && this.xid.equals(xid)) {
                throw new XAException(-8);
            }
            throw new XAException(-6);
        }
        if (this.xid != null && !this.xid.equals(xid)) {
            throw new XAException(-4);
        }
        this.xid = xid;
        this.active = true;
        this.monStart = new Date().getTime();
        this.log.debug((Object)("transaction started : " + this.monStart + " - " + xid.toString()));
    }

    public void end(Xid xid, int flag) throws XAException {
        if (!this.active) {
            throw new XAException(-6);
        }
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException(-4);
        }
        this.active = false;
        long monEnd = new Date().getTime();
        this.log.debug((Object)("transaction ended : " + this.monStart + " # " + monEnd + " - " + xid.toString()));
    }

    public void forget(Xid xid) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException(-4);
        }
        this.xid = null;
        if (this.active) {
            this.log.warn((Object)"forget() called without end()");
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException(-4);
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.xid == null) {
            return new Xid[0];
        }
        return new Xid[]{this.xid};
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeout = seconds;
        return true;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.log.debug((Object)("Xid : " + xid.toString() + " cleared [commit]"));
    }

    public void rollback(Xid xid) throws XAException {
        this.log.debug((Object)("Xid : " + xid.toString() + " cleared [rollback]"));
    }

    public void connectionClosed(ConnectionEvent event) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        Object source = event.getSource();
        SQLException e = event.getSQLException();
        this.log.warn((Object)("connection error : " + source + " : "), (Throwable)e);
    }
}

