/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa.wrapper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.PoolEvent;
import org.ofbiz.minerva.pool.PoolEventListener;
import org.ofbiz.minerva.pool.PooledObject;
import org.ofbiz.minerva.pool.cache.ObjectCache;
import org.ofbiz.minerva.pool.jdbc.ConnectionInPool;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.TransactionListener;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAClientConnection;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XAConnectionImpl
implements XAConnectionExt,
PooledObject {
    private static final String CLOSED = "Connection has been closed!";
    private Connection con;
    private XAResourceImpl resource;
    private int preparedStatementCacheSize = 0;
    private int clientConnectionCount = 0;
    private String user;
    private String password;
    private boolean saveStackTrace;
    private Logger log = Logger.getLogger(XAConnectionImpl.class);
    private Vector listeners;
    private Vector poolListeners;
    private ArrayList clientConnections;
    private TransactionListener transListener;

    public XAConnectionImpl(Connection con, XAResourceImpl resource, boolean saveStackTrace) {
        this.con = con;
        this.resource = resource;
        this.listeners = new Vector();
        this.poolListeners = new Vector();
        this.clientConnections = new ArrayList();
        this.saveStackTrace = saveStackTrace;
    }

    public void setTransactionListener(TransactionListener tl) {
        this.transListener = tl;
    }

    public void clearTransactionListener() {
        this.transListener = null;
    }

    public void setPSCacheSize(int maxSize) {
        this.preparedStatementCacheSize = maxSize;
    }

    public int getPSCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setTransactionIsolation(int iso) throws SQLException {
        this.con.setTransactionIsolation(iso);
    }

    public void close() {
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.log.trace((Object)e);
        }
        ObjectCache cache = (ObjectCache)ConnectionInPool.psCaches.remove(this.con);
        if (cache != null) {
            cache.close();
        }
        this.con = null;
        this.resource = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public synchronized void clientConnectionClosed(XAClientConnection clientCon) {
        this.clientConnections.remove(clientCon);
        if (this.clientConnections.size() > 0) {
            return;
        }
        Vector local = (Vector)this.listeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            ((ConnectionEventListener)local.elementAt(i)).connectionClosed(new ConnectionEvent(this));
        }
    }

    public void transactionFinished() {
        if (this.transListener != null) {
            this.transListener.transactionFinished(this);
        }
    }

    public void transactionFailed() {
        if (this.transListener != null) {
            this.transListener.transactionFailed(this);
        }
    }

    public void setConnectionError(SQLException e) {
        Vector local = (Vector)this.listeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            try {
                ((ConnectionEventListener)local.elementAt(i)).connectionErrorOccurred(new ConnectionEvent(this, e));
                continue;
            }
            catch (RuntimeException ex) {
                this.log.error((Object)ex);
            }
        }
    }

    public void rollback() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback();
        }
    }

    public XAResourceImpl getXAResourceImpl() {
        return this.resource;
    }

    public XAResource getXAResource() {
        return this.resource;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized Connection getConnection() {
        XAClientConnection xaCon = new XAClientConnection(this, this.con, this.saveStackTrace);
        xaCon.setPSCacheSize(this.preparedStatementCacheSize);
        this.clientConnections.add(xaCon);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("new XAClientConnection created; added to clientConnections size: " + this.clientConnections.size()));
        }
        return xaCon;
    }

    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public void addPoolEventListener(PoolEventListener listener) {
        this.poolListeners.addElement(listener);
    }

    public void removePoolEventListener(PoolEventListener listener) {
        this.poolListeners.removeElement(listener);
    }

    public void objectGc() {
        XAResourceImpl res = this.getXAResourceImpl();
        if (res != null && res.isTransaction()) {
            this.log.warn((Object)("GC connection is active in transaction xid: " + res.getCurrent()));
            PoolEvent evt = new PoolEvent(this, -8986433);
            evt.setCatastrophic();
            this.firePoolEvent(evt);
            Transaction trans = res.getTransaction();
            if (trans != null) {
                try {
                    trans.rollback();
                }
                catch (SystemException e) {
                    this.log.error((Object)"error rolling back stale connection", (Throwable)e);
                }
            } else {
                this.log.error((Object)"error rolling back stale connection; no transaction found");
            }
        }
    }

    public void firePoolEvent(PoolEvent evt) {
        Vector local = (Vector)this.poolListeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            if (evt.getType() == -8986432) {
                ((PoolEventListener)local.elementAt(i)).objectClosed(evt);
                continue;
            }
            if (evt.getType() == -8986433) {
                ((PoolEventListener)local.elementAt(i)).objectError(evt);
                continue;
            }
            ((PoolEventListener)local.elementAt(i)).objectUsed(evt);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void forceClientConnectionsClose() {
        for (int i = 0; i < this.clientConnections.size(); ++i) {
            XAClientConnection client = (XAClientConnection)this.clientConnections.get(i);
            try {
                client.forcedClose();
                continue;
            }
            catch (SQLException ignored) {
                this.log.debug((Object)"unable for force connection to close", (Throwable)ignored);
            }
        }
        this.clientConnections.clear();
    }
}

