/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.PoolEvent;
import org.ofbiz.minerva.pool.cache.LeastRecentlyUsedCache;
import org.ofbiz.minerva.pool.cache.ObjectCache;
import org.ofbiz.minerva.pool.jdbc.ConnectionInPool;
import org.ofbiz.minerva.pool.jdbc.ConnectionWrapper;
import org.ofbiz.minerva.pool.jdbc.PreparedStatementFactory;
import org.ofbiz.minerva.pool.jdbc.PreparedStatementInPool;
import org.ofbiz.minerva.pool.jdbc.StatementInPool;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XAClientConnection
implements ConnectionWrapper {
    private static final String CLOSED = "Connection has been closed!";
    private Connection con;
    private HashSet statements;
    private Vector listeners;
    private XAConnectionExt xaCon;
    private int preparedStatementCacheSize = 0;
    private ObjectCache preparedStatementCache;
    private String stackTrace = null;
    private static Logger log = Logger.getLogger(XAClientConnection.class);

    public XAClientConnection(XAConnectionExt xaCon, Connection con, boolean saveStackTrace) {
        this.con = con;
        this.xaCon = xaCon;
        this.preparedStatementCache = (ObjectCache)ConnectionInPool.psCaches.get(con);
        if (this.preparedStatementCache == null) {
            PreparedStatementFactory factory = new PreparedStatementFactory(con);
            this.preparedStatementCache = new LeastRecentlyUsedCache(factory, this.preparedStatementCacheSize);
            ConnectionInPool.psCaches.put(con, this.preparedStatementCache);
        }
        this.statements = new HashSet();
        this.listeners = new Vector();
        if (saveStackTrace) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream(baos);
                new Throwable().printStackTrace(stream);
                baos.close();
                this.stackTrace = baos.toString();
            }
            catch (Exception ex) {
                log.trace((Object)ex);
            }
        }
    }

    public void setPSCacheSize(int maxSize) {
        this.preparedStatementCacheSize = maxSize;
        if (this.preparedStatementCache != null) {
            this.preparedStatementCache.setSize(maxSize);
        }
    }

    public int getPSCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public void shutdown() {
        this.con = null;
        this.statements = null;
        this.listeners = null;
        this.xaCon = null;
    }

    public void setLastUsed() {
        this.xaCon.firePoolEvent(new PoolEvent(this.xaCon, -8986434));
    }

    public void setError(SQLException e) {
        this.xaCon.setConnectionError(e);
    }

    public void statementClosed(Statement st) {
        this.statements.remove(st);
        if (this.con != null && st instanceof PreparedStatementInPool && this.preparedStatementCacheSize != 0) {
            PreparedStatementInPool ps = (PreparedStatementInPool)st;
            PreparedStatement ups = ps.getUnderlyingPreparedStatement();
            this.preparedStatementCache.returnObject(ps.getSql(), ups);
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            StatementInPool st = new StatementInPool(this.con.createStatement(), this);
            this.statements.add(st);
            return st;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            PreparedStatement ps = this.preparedStatementCacheSize == 0 ? this.con.prepareStatement(sql) : (PreparedStatement)this.preparedStatementCache.useObject(sql);
            if (ps == null) {
                throw new SQLException("Unable to create PreparedStatement!");
            }
            PreparedStatementInPool wrapper = new PreparedStatementInPool(ps, this, sql);
            this.statements.add(wrapper);
            return wrapper;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        if (((XAResourceImpl)this.xaCon.getXAResource()).isTransaction() && autoCommit) {
            throw new SQLException("Cannot set AutoCommit for a transactional connection: See JDBC 2.0 Optional Package Specification section 7.1 (p25)");
        }
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void commit() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        if (((XAResourceImpl)this.xaCon.getXAResource()).isTransaction()) {
            throw new SQLException("Cannot commit a transactional connection: See JDBC 2.0 Optional Package Specification section 7.1 (p25)");
        }
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        if (((XAResourceImpl)this.xaCon.getXAResource()).isTransaction()) {
            throw new SQLException("Cannot rollback a transactional connection: See JDBC 2.0 Optional Package Specification section 7.1 (p25)");
        }
    }

    public void forcedClose() throws SQLException {
        if (this.stackTrace != null) {
            log.warn((Object)("A forced close because a non-closed connection:\n" + this.stackTrace));
        }
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        Collection copy = (Collection)this.statements.clone();
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            try {
                ((Statement)it.next()).close();
            }
            catch (SQLException e) {
                log.warn((Object)"SQLException : ", (Throwable)e);
            }
        }
        this.shutdown();
    }

    public void close() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        Collection copy = (Collection)this.statements.clone();
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            try {
                ((Statement)it.next()).close();
            }
            catch (SQLException e) {
                log.warn((Object)"SQLException : ", (Throwable)e);
            }
        }
        this.xaCon.clientConnectionClosed(this);
        this.shutdown();
    }

    public boolean isClosed() throws SQLException {
        if (this.con == null) {
            return true;
        }
        try {
            return this.con.isClosed();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            StatementInPool st = new StatementInPool(this.con.createStatement(resultSetType, resultSetConcurrency), this);
            this.statements.add(st);
            return st;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public void rollback(Savepoint arg0) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        throw new SQLException("Method not implemented!");
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        throw new SQLException("Method not implemented!");
    }
}

