/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.jdbc.xa.XAPoolDataSource;

public class XAPoolDriver
implements Driver {
    private static final Logger log = Logger.getLogger(XAPoolDriver.class);
    private static final String URL_START = "jdbc:minerva:xa:";
    private static final XAPoolDriver instance = new XAPoolDriver();

    public static XAPoolDriver instance() {
        return instance;
    }

    private XAPoolDriver() {
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_START);
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (url.startsWith(URL_START)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("connecting to url: " + url));
            }
            return this.getXAConnection(url.substring(URL_START.length()));
        }
        return null;
    }

    private Connection getXAConnection(String name) {
        Connection con = null;
        try {
            XAPoolDataSource source = XAPoolDataSource.getDataSource(name);
            if (source != null) {
                con = source.getConnection();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("received datasource from XAPoolDataSource:" + con.toString()));
                }
            } else {
                log.trace((Object)"no connection from XAPoolDataSource");
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't get DataSource from XA Connection Pool", (Throwable)e);
        }
        return con;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(XAPoolDriver.instance());
        }
        catch (SQLException e) {
            log.error((Object)"Unable to register Minerva XA DB pool driver!", (Throwable)e);
        }
    }
}

