/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.ofbiz.base.util.Log4jLoggerWriter;
import org.ofbiz.minerva.pool.ObjectPool;
import org.ofbiz.minerva.pool.jdbc.spy.SpyDataSource;
import org.ofbiz.minerva.pool.jdbc.xa.XAConnectionFactory;
import org.ofbiz.minerva.pool.jdbc.xa.XAPoolDriver;

public class XAPoolDataSource
implements DataSource,
Referenceable,
ObjectFactory,
Serializable {
    private static transient Logger log = Logger.getLogger(XAPoolDataSource.class);
    private static transient HashMap sources = new HashMap();
    private transient ObjectPool pool;
    private transient XAConnectionFactory factory;
    private transient PrintWriter logWriter;
    private transient int timeout;
    private transient boolean initialized = false;
    private transient String jndiName;
    private boolean spy = false;
    private String name;

    public static Collection getDataSources() {
        return new HashSet(sources.values());
    }

    public static XAPoolDataSource getDataSource(String poolName) {
        return (XAPoolDataSource)sources.get(poolName);
    }

    public XAPoolDataSource() {
        log.info((Object)"Creating Minerva XA Connection Pool");
        this.pool = new ObjectPool();
        this.factory = new XAConnectionFactory();
        log.debug((Object)"Created factory");
        XAPoolDriver.instance();
        log.debug((Object)"got driver instance");
        this.spy = "true".equalsIgnoreCase(System.getProperty("ofbiz.minerva.spy"));
        log.debug((Object)("Spy enabled: " + this.spy));
    }

    public void setJNDIName(String name) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding to JNDI name " + name));
        }
        InitialContext ctx = new InitialContext();
        if (this.jndiName != null && !this.jndiName.equals(name)) {
            ctx.unbind(this.jndiName);
        }
        if (name != null) {
            ctx.bind(name, (Object)this);
        }
        this.jndiName = name;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setDataSource(XADataSource ds) {
        if (this.spy) {
            this.factory.setDataSource(new SpyDataSource(this.factory, ds));
        } else {
            this.factory.setDataSource(ds);
        }
    }

    public XADataSource getDataSource() {
        return this.factory.getDataSource();
    }

    public void setTransactionManager(TransactionManager tm) {
        this.factory.setTransactionManager(tm);
    }

    public void setJDBCUser(String user) {
        this.factory.setUser(user);
    }

    public String getJDBCUser() {
        return this.factory.getUser();
    }

    public void setJDBCPassword(String password) {
        this.factory.setPassword(password);
    }

    public String getJDBCPassword() {
        return this.factory.getPassword();
    }

    public int getTransactionIsolation() {
        return this.factory.getTransactionIsolation();
    }

    public void setTransactionIsolation(int iso) {
        this.factory.setTransactionIsolation(iso);
    }

    public void setTransactionIsolation(String iso) {
        this.factory.setTransactionIsolation(iso);
    }

    public int getPSCacheSize() {
        return this.factory.getPSCacheSize();
    }

    public void setPSCacheSize(int size) {
        this.factory.setPSCacheSize(size);
    }

    public boolean getReleaseOnCommit() {
        return this.factory.getReleaseOnCommit();
    }

    public void setReleaseOnCommit(boolean rel) {
        this.factory.setReleaseOnCommit(rel);
    }

    public boolean getSaveStackTrace() {
        return this.factory.getSaveStackTrace();
    }

    public void setSaveStackTrace(boolean save) {
        this.factory.setSaveStackTrace(save);
    }

    public void setPoolName(String name) {
        this.name = name;
        this.pool.setName(name);
        sources.put(this.pool.getName(), this);
    }

    public String getPoolName() {
        return this.name;
    }

    public void setMinSize(int size) {
        this.pool.setMinSize(size);
    }

    public int getMinSize() {
        return this.pool.getMinSize();
    }

    public void setMaxSize(int size) {
        this.pool.setMaxSize(size);
    }

    public int getMaxSize() {
        return this.pool.getMaxSize();
    }

    public void setBlocking(boolean blocking) {
        this.pool.setBlocking(blocking);
    }

    public boolean isBlocking() {
        return this.pool.isBlocking();
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.pool.setBlockingTimeout(blockingTimeout);
    }

    public int getBlockingTimeout() {
        return this.pool.getBlockingTimeout();
    }

    public void setIdleTimeoutEnabled(boolean allowShrinking) {
        this.pool.setIdleTimeoutEnabled(allowShrinking);
    }

    public boolean isIdleTimeoutEnabled() {
        return this.pool.isIdleTimeoutEnabled();
    }

    public void setGCEnabled(boolean allowGC) {
        this.pool.setGCEnabled(allowGC);
    }

    public boolean isGCEnabled() {
        return this.pool.isGCEnabled();
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        this.pool.setMaxIdleTimeoutPercent(percent);
    }

    public float getMaxIdleTimeoutPercent() {
        return this.pool.getMaxIdleTimeoutPercent();
    }

    public void setIdleTimeout(long millis) {
        this.pool.setIdleTimeout(millis);
    }

    public long getIdleTimeout() {
        return this.pool.getIdleTimeout();
    }

    public void setGCMinIdleTime(long millis) {
        this.pool.setGCMinIdleTime(millis);
    }

    public long getGCMinIdleTime() {
        return this.pool.getGCMinIdleTime();
    }

    public void setGCInterval(long millis) {
        this.pool.setGCInterval(millis);
    }

    public long getGCInterval() {
        return this.pool.getGCInterval();
    }

    public void setInvalidateOnError(boolean invalidate) {
        this.pool.setInvalidateOnError(invalidate);
    }

    public boolean isInvalidateOnError() {
        return this.pool.isInvalidateOnError();
    }

    public void setTimestampUsed(boolean timestamp) {
        this.pool.setTimestampUsed(timestamp);
    }

    public boolean isTimestampUsed() {
        return this.pool.isTimestampUsed();
    }

    public void initialize() {
        this.initialized = true;
        this.pool.setObjectFactory(this.factory);
        this.pool.initialize();
    }

    public String getPoolStatus() {
        return this.pool.toString();
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing DataSource");
        }
        try {
            this.setJNDIName(null);
        }
        catch (NamingException e) {
            log.warn((Object)"Can't unbind from JNDI", (Throwable)e);
        }
        sources.remove(this.pool.getName());
        this.pool.shutDown();
        this.pool = null;
        this.factory = null;
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        log.trace((Object)"Getting a Connection");
        String user = this.factory.getUser();
        String password = this.factory.getPassword();
        String[] params = new String[]{user, password};
        try {
            XAConnection xaConn = (XAConnection)this.pool.getObject(params);
            return xaConn.getConnection();
        }
        catch (RuntimeException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting a connection for user " + user + " with password " + password));
        }
        String[] params = new String[]{user, password};
        try {
            XAConnection xaConn = (XAConnection)this.pool.getObject(params);
            return xaConn.getConnection();
        }
        catch (RuntimeException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (writer == null) {
            this.logWriter = null;
        } else if (this.logWriter == null) {
            this.logWriter = new Log4jLoggerWriter(log);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.timeout = timeout;
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName(), new StringRefAddr("XAPool", this.pool.getName()), this.getClass().getName(), null);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        Reference ref;
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(this.getClass().getName())) {
            RefAddr addr = ref.get("XAPool");
            return sources.get(addr.getContent());
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            InitialContext ctx = new InitialContext();
            return ctx.lookup("java:/" + this.name);
        }
        catch (NamingException e) {
            throw new InvalidObjectException("problem finding correct datasource instance" + e);
        }
    }

    public Set getPooledObjectRecords(int inUse) {
        return this.pool.getPooledObjects(inUse);
    }

    public String getPoolDataString() {
        return this.pool.toString();
    }
}

