/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.xa;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.ObjectPool;
import org.ofbiz.minerva.pool.PoolObjectFactory;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.TransactionListener;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XADataSourceImpl;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XAConnectionFactory
extends PoolObjectFactory {
    public static final int DEFAULT_ISOLATION = -1;
    private XADataSource source;
    private String userName;
    private String password;
    private int psCacheSize = 10;
    private boolean releaseOnCommit = false;
    private boolean saveStackTrace = false;
    private int transactionIsolation = -1;
    private ConnectionEventListener listener;
    private ConnectionEventListener errorListener;
    private TransactionListener transListener;
    private ObjectPool pool;
    private final Map wrapperTx = Collections.synchronizedMap(new HashMap());
    private final Map rms = Collections.synchronizedMap(new HashMap());
    private TransactionManager tm;
    private static Logger log = Logger.getLogger(XAConnectionFactory.class);

    public XAConnectionFactory() {
        final boolean trace = log.isDebugEnabled();
        this.errorListener = new ConnectionEventListener(){

            public void connectionErrorOccurred(ConnectionEvent evt) {
                if (XAConnectionFactory.this.pool.isInvalidateOnError()) {
                    XAConnectionFactory.this.pool.markObjectAsInvalid(evt.getSource());
                }
            }

            public void connectionClosed(ConnectionEvent evt) {
            }
        };
        this.listener = new ConnectionEventListener(){

            public void connectionErrorOccurred(ConnectionEvent evt) {
                if (XAConnectionFactory.this.pool.isInvalidateOnError()) {
                    XAConnectionFactory.this.pool.markObjectAsInvalid(evt.getSource());
                }
            }

            public void connectionClosed(ConnectionEvent evt) {
                this.closeConnection(evt, 0x4000000);
            }

            private void closeConnection(ConnectionEvent evt, int status) {
                XAConnection con = (XAConnection)evt.getSource();
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.listener);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                try {
                    if (XAConnectionFactory.this.tm.getStatus() != 6) {
                        Transaction trans = XAConnectionFactory.this.tm.getTransaction();
                        XAResource res = (XAResource)XAConnectionFactory.this.rms.remove(con);
                        if (res != null) {
                            trans.delistResource(res, status);
                            if (trace) {
                                log.debug((Object)("delisted resource from TM - " + res));
                            }
                        } else {
                            log.warn((Object)("no xares in rms for con " + con));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unable to deregister with TransactionManager", (Throwable)e);
                    throw new RuntimeException("Unable to deregister with TransactionManager: " + e);
                }
                if (!(con instanceof XAConnectionExt)) {
                    XAConnectionFactory.this.pool.releaseObject(con);
                } else {
                    XAConnectionExt cext = (XAConnectionExt)con;
                    XAResourceImpl res = cext.getXAResourceImpl();
                    if (!res.isTransaction()) {
                        if (trace) {
                            log.debug((Object)("XAConnectionExt: " + con + " has no current tx!"));
                        }
                        try {
                            cext.rollback();
                        }
                        catch (SQLException e) {
                            XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                        }
                        XAConnectionFactory.this.pool.releaseObject(con);
                    } else {
                        con.addConnectionEventListener(XAConnectionFactory.this.errorListener);
                    }
                }
            }
        };
        this.transListener = new TransactionListener(){

            public void transactionFinished(XAConnectionExt con) {
                con.clearTransactionListener();
                Object tx = XAConnectionFactory.this.wrapperTx.remove(con);
                if (tx != null) {
                    XAConnectionFactory.this.wrapperTx.remove(tx);
                }
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.errorListener);
                }
                catch (IllegalArgumentException e) {
                    if (!XAConnectionFactory.this.releaseOnCommit) {
                        return;
                    }
                    XAConnectionFactory.this.rms.remove(con);
                    XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                    con.forceClientConnectionsClose();
                }
                XAConnectionFactory.this.pool.releaseObject(con);
            }

            public void transactionFailed(XAConnectionExt con) {
                con.clearTransactionListener();
                Object tx = XAConnectionFactory.this.wrapperTx.remove(con);
                if (tx != null) {
                    XAConnectionFactory.this.wrapperTx.remove(tx);
                }
                XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.errorListener);
                }
                catch (IllegalArgumentException e) {
                    if (!XAConnectionFactory.this.releaseOnCommit) {
                        return;
                    }
                    XAConnectionFactory.this.rms.remove(con);
                    con.forceClientConnectionsClose();
                }
                XAConnectionFactory.this.pool.releaseObject(con);
            }
        };
    }

    public void setUser(String userName) {
        this.userName = userName;
    }

    public String getUser() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getReleaseOnCommit() {
        return this.releaseOnCommit;
    }

    public void setReleaseOnCommit(boolean rel) {
        this.releaseOnCommit = rel;
    }

    public void setPSCacheSize(int size) {
        this.psCacheSize = size;
    }

    public int getPSCacheSize() {
        return this.psCacheSize;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int iso) {
        this.transactionIsolation = iso;
    }

    public void setTransactionIsolation(String iso) {
        if (iso.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (iso.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (iso.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (iso.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (iso.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            throw new IllegalArgumentException("Setting Isolation level to unknown state: " + iso);
        }
    }

    public void setDataSource(XADataSource dataSource) {
        this.source = dataSource;
    }

    public XADataSource getDataSource() {
        return this.source;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean getSaveStackTrace() {
        return this.saveStackTrace;
    }

    public void setSaveStackTrace(boolean save) {
        this.saveStackTrace = save;
    }

    public void poolStarted(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting");
        }
        super.poolStarted(pool);
        this.pool = pool;
        if (this.source == null) {
            throw new IllegalStateException("Must specify XADataSource to " + this.getClass().getName());
        }
        if (this.source instanceof XADataSourceImpl) {
            ((XADataSourceImpl)this.source).setSaveStackTrace(this.saveStackTrace);
        }
    }

    public Object createObject(Object parameters) throws Exception {
        log.debug((Object)"Opening new XAConnection");
        XAConnection obj = null;
        try {
            if (parameters != null) {
                String[] credentials = (String[])parameters;
                if (credentials.length == 2) {
                    obj = this.source.getXAConnection(credentials[0], credentials[1]);
                }
            } else {
                obj = this.userName != null && this.userName.length() > 0 ? this.source.getXAConnection(this.userName, this.password) : this.source.getXAConnection();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Can't get an XAConnection", (Throwable)e);
            throw e;
        }
        return obj;
    }

    public Object prepareObject(Object pooledObject) {
        boolean trace = log.isDebugEnabled();
        XAConnection con = (XAConnection)pooledObject;
        con.addConnectionEventListener(this.listener);
        Transaction trans = null;
        try {
            if (this.tm.getStatus() != 6) {
                trans = this.tm.getTransaction();
                XAResource res = con.getXAResource();
                this.rms.put(con, res);
                trans.enlistResource(res);
                if (res instanceof XAResourceImpl) {
                    ((XAResourceImpl)res).setTransaction(trans);
                }
                if (trace) {
                    log.debug((Object)("Resource '" + res + "' enlisted for '" + con + "'."));
                }
            } else if (trace) {
                log.debug((Object)"No transaction right now.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Unable to register with TransactionManager", (Throwable)e);
            con.removeConnectionEventListener(this.listener);
            throw new RuntimeException("Unable to register with TransactionManager: " + e);
        }
        if (con instanceof XAConnectionExt) {
            ((XAConnectionExt)con).setTransactionListener(this.transListener);
            ((XAConnectionExt)con).setPSCacheSize(this.psCacheSize);
            if (this.transactionIsolation != -1) {
                try {
                    ((XAConnectionExt)con).setTransactionIsolation(this.transactionIsolation);
                }
                catch (SQLException sex) {
                    throw new RuntimeException("Unable to setTransactionIsolation: " + sex.getMessage());
                }
            }
            if (trans != null) {
                this.wrapperTx.put(con, trans);
                this.wrapperTx.put(trans, con);
            }
        }
        return con;
    }

    public void deleteObject(Object pooledObject) {
        XAConnection con = (XAConnection)pooledObject;
        try {
            con.close();
        }
        catch (SQLException e) {
            log.trace((Object)e);
        }
    }

    public Object isUniqueRequest() {
        try {
            if (this.tm.getStatus() != 6) {
                Transaction trans = this.tm.getTransaction();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("isUniqueRequest returning conn: " + this.wrapperTx.get(trans) + "  attached to tx: " + trans));
                }
                return this.wrapperTx.get(trans);
            }
        }
        catch (Exception e) {
            log.trace((Object)e);
        }
        return null;
    }

    public boolean checkValidObject(Object source, Object parameters) {
        boolean validObject = true;
        if (parameters != null && source instanceof XAConnectionExt) {
            XAConnectionExt con = (XAConnectionExt)source;
            String[] credentials = (String[])parameters;
            if (credentials.length == 2) {
                String user = con.getUser();
                String password = con.getPassword();
                boolean validUser = user == null && credentials[0] == null || user != null && user.equals(credentials[0]);
                boolean validPassword = password == null && credentials[1] == null || password != null && password.equals(credentials[1]);
                validObject = validUser && validPassword;
            }
        }
        return validObject;
    }
}

