/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.spy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.PoolEvent;
import org.ofbiz.minerva.pool.PoolEventListener;
import org.ofbiz.minerva.pool.PooledObject;
import org.ofbiz.minerva.pool.jdbc.spy.SpyConnection;
import org.ofbiz.minerva.pool.jdbc.xa.XAConnectionFactory;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.TransactionListener;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAClientConnection;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionImpl;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAResourceImpl;

public class SpyXAConnection
implements XAConnectionExt,
PooledObject {
    private static Logger log = Logger.getLogger(SpyXAConnection.class);
    private XAConnectionFactory factory;
    private XAConnectionImpl xaCon;
    private Vector listeners;
    private Vector poolListeners;
    private ArrayList clientConnections;
    private TransactionListener transListener;

    public SpyXAConnection(XAConnectionImpl xaCon, XAConnectionFactory factory) {
        this.factory = factory;
        this.xaCon = xaCon;
        this.listeners = new Vector();
        this.poolListeners = new Vector();
        this.clientConnections = new ArrayList();
        XAResourceImpl res = this.xaCon.getXAResourceImpl();
        res.setXAConnection(this, true);
    }

    public XAResource getXAResource() throws SQLException {
        return this.xaCon.getXAResource();
    }

    public synchronized Connection getConnection() {
        XAClientConnection client = new XAClientConnection(this, this.xaCon.getUnderlyingConnection(), true);
        client.setPSCacheSize(this.xaCon.getPSCacheSize());
        this.clientConnections.add(client);
        if (log.isTraceEnabled()) {
            log.trace((Object)("new SpyXAConnection created; added to clientConnections size: " + this.clientConnections.size()));
        }
        return new SpyConnection(this.factory, this, client);
    }

    public void close() throws SQLException {
        this.xaCon.close();
        this.listeners.clear();
        this.listeners = null;
    }

    public void objectGc() {
        XAResourceImpl res = this.getXAResourceImpl();
        if (res != null && res.isTransaction()) {
            log.warn((Object)("GC connection is active in transaction xid: " + res.getCurrent()));
            PoolEvent evt = new PoolEvent(this, -8986433);
            evt.setCatastrophic();
            this.firePoolEvent(evt);
            Transaction trans = res.getTransaction();
            if (trans != null) {
                try {
                    trans.rollback();
                }
                catch (SystemException e) {
                    log.error((Object)"error rolling back stale connection", (Throwable)e);
                }
            } else {
                log.error((Object)"error rolling back stale connection; no transaction found");
            }
        }
    }

    public void addPoolEventListener(PoolEventListener listener) {
        this.poolListeners.addElement(listener);
    }

    public void removePoolEventListener(PoolEventListener listener) {
        this.poolListeners.removeElement(listener);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException();
        }
    }

    public String getPassword() {
        return this.xaCon.getPassword();
    }

    public String getUser() {
        return this.xaCon.getUser();
    }

    public void rollback() throws SQLException {
        this.xaCon.rollback();
    }

    public void transactionFinished() {
        if (this.transListener != null) {
            this.transListener.transactionFinished(this);
        }
    }

    public void transactionFailed() {
        if (this.transListener != null) {
            this.transListener.transactionFailed(this);
        }
    }

    public void setTransactionIsolation(int iso) throws SQLException {
        this.xaCon.setTransactionIsolation(iso);
    }

    public void setPSCacheSize(int maxSize) {
        this.xaCon.setPSCacheSize(maxSize);
    }

    public int getPSCacheSize() {
        return this.xaCon.getPSCacheSize();
    }

    public void setTransactionListener(TransactionListener tl) {
        this.transListener = tl;
    }

    public void clearTransactionListener() {
        this.transListener = null;
    }

    public void forceClientConnectionsClose() {
        this.xaCon.forceClientConnectionsClose();
    }

    public void setConnectionError(SQLException e) {
        Vector local = (Vector)this.listeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            try {
                ((ConnectionEventListener)local.elementAt(i)).connectionErrorOccurred(new ConnectionEvent(this, e));
                continue;
            }
            catch (RuntimeException ex) {
                log.error((Object)ex);
            }
        }
    }

    public XAResourceImpl getXAResourceImpl() {
        return this.xaCon.getXAResourceImpl();
    }

    public synchronized void clientConnectionClosed(XAClientConnection clientCon) {
        this.clientConnections.remove(clientCon);
        if (this.clientConnections.size() > 0) {
            return;
        }
        Vector local = (Vector)this.listeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            ((ConnectionEventListener)local.elementAt(i)).connectionClosed(new ConnectionEvent(this));
        }
    }

    public void firePoolEvent(PoolEvent evt) {
        Vector local = (Vector)this.poolListeners.clone();
        for (int i = local.size() - 1; i >= 0; --i) {
            if (evt.getType() == -8986432) {
                ((PoolEventListener)local.elementAt(i)).objectClosed(evt);
                continue;
            }
            if (evt.getType() == -8986433) {
                ((PoolEventListener)local.elementAt(i)).objectError(evt);
                continue;
            }
            ((PoolEventListener)local.elementAt(i)).objectUsed(evt);
        }
    }
}

