/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.spy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.jdbc.spy.SpyConnection;
import org.ofbiz.minerva.pool.jdbc.spy.SpyResultSet;

public class SpyPreparedStatement
implements PreparedStatement {
    private Logger log = Logger.getLogger(SpyPreparedStatement.class);
    private SpyConnection spyCon;
    private PreparedStatement ps;
    private String query;

    public SpyPreparedStatement(SpyConnection spyCon, PreparedStatement ps, String query) {
        this.spyCon = spyCon;
        this.ps = ps;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this.ps.executeQuery();
            return resultSet;
        }
        finally {
            this.log.debug((Object)("execute query : " + this.query));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        try {
            int n = this.ps.executeUpdate();
            return n;
        }
        finally {
            this.log.debug((Object)("execute update : " + this.query));
        }
    }

    public void setNull(int i, int i1) throws SQLException {
        this.ps.setNull(i, i1);
    }

    public void setBoolean(int i, boolean b) throws SQLException {
        this.ps.setBoolean(i, b);
    }

    public void setByte(int i, byte b) throws SQLException {
        this.ps.setByte(i, b);
    }

    public void setShort(int i, short i1) throws SQLException {
        this.ps.setShort(i, i1);
    }

    public void setInt(int i, int i1) throws SQLException {
        this.ps.setInt(i, i1);
    }

    public void setLong(int i, long l) throws SQLException {
        this.ps.setLong(i, l);
    }

    public void setFloat(int i, float v) throws SQLException {
        this.ps.setFloat(i, v);
    }

    public void setDouble(int i, double v) throws SQLException {
        this.ps.setDouble(i, v);
    }

    public void setBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
        this.ps.setBigDecimal(i, bigDecimal);
    }

    public void setString(int i, String string) throws SQLException {
        this.ps.setString(i, string);
    }

    public void setBytes(int i, byte[] bytes) throws SQLException {
        this.ps.setBytes(i, bytes);
    }

    public void setDate(int i, Date date) throws SQLException {
        this.ps.setDate(i, date);
    }

    public void setTime(int i, Time time) throws SQLException {
        this.ps.setTime(i, time);
    }

    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.ps.setTimestamp(i, timestamp);
    }

    public void setAsciiStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.ps.setAsciiStream(i, inputStream, i1);
    }

    @Deprecated
    public void setUnicodeStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.ps.setUnicodeStream(i, inputStream, i1);
    }

    public void setBinaryStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.ps.setBinaryStream(i, inputStream, i1);
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void setObject(int i, Object object, int i1, int i2) throws SQLException {
        this.ps.setObject(i, object, i1, i2);
    }

    public void setObject(int i, Object object, int i1) throws SQLException {
        this.ps.setObject(i, object, i1);
    }

    public void setObject(int i, Object object) throws SQLException {
        this.ps.setObject(i, object);
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void setCharacterStream(int i, Reader reader, int i1) throws SQLException {
        this.ps.setCharacterStream(i, reader, i1);
    }

    public void setRef(int i, Ref ref) throws SQLException {
        this.ps.setRef(i, ref);
    }

    public void setBlob(int i, Blob blob) throws SQLException {
        this.ps.setBlob(i, blob);
    }

    public void setClob(int i, Clob clob) throws SQLException {
        this.ps.setClob(i, clob);
    }

    public void setArray(int i, Array array) throws SQLException {
        this.ps.setArray(i, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        this.ps.setDate(i, date, calendar);
    }

    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        this.ps.setTime(i, time, calendar);
    }

    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.ps.setTimestamp(i, timestamp, calendar);
    }

    public void setNull(int i, int i1, String string) throws SQLException {
        this.ps.setNull(i, i1, string);
    }

    public void setURL(int i, URL url) throws SQLException {
        this.ps.setURL(i, url);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            SpyResultSet spyResultSet = new SpyResultSet(this.ps.executeQuery(string));
            return spyResultSet;
        }
        finally {
            this.log.debug((Object)("execute query : " + this.query + "/ " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        try {
            int n = this.ps.executeUpdate(string);
            return n;
        }
        finally {
            this.log.debug((Object)("execute update : " + this.query));
        }
    }

    public void close() throws SQLException {
        this.ps.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public void setMaxFieldSize(int i) throws SQLException {
        this.ps.setMaxFieldSize(i);
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public void setMaxRows(int i) throws SQLException {
        this.ps.setMaxRows(i);
    }

    public void setEscapeProcessing(boolean b) throws SQLException {
        this.ps.setEscapeProcessing(b);
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public void setQueryTimeout(int i) throws SQLException {
        this.ps.setQueryTimeout(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            this.ps.cancel();
        }
        finally {
            this.log.debug((Object)"prepared statment : cancel()");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.ps.setCursorName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        try {
            boolean bl = this.ps.execute(string);
            return bl;
        }
        finally {
            this.log.debug((Object)("execute : " + string));
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return new SpyResultSet(this.ps.getResultSet());
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public void setFetchDirection(int i) throws SQLException {
        this.ps.setFetchDirection(i);
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public void setFetchSize(int i) throws SQLException {
        this.ps.setFetchSize(i);
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public void addBatch(String string) throws SQLException {
        this.ps.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.spyCon;
    }

    public boolean getMoreResults(int i) throws SQLException {
        return this.ps.getMoreResults(i);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new SpyResultSet(this.ps.getGeneratedKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int i) throws SQLException {
        try {
            int n = this.ps.executeUpdate(string, i);
            return n;
        }
        finally {
            this.log.debug((Object)("execute update : " + this.query + " / " + string));
        }
    }

    public int executeUpdate(String string, int[] ints) throws SQLException {
        return this.ps.executeUpdate(string, ints);
    }

    public int executeUpdate(String string, String[] strings) throws SQLException {
        return this.ps.executeUpdate(string, strings);
    }

    public boolean execute(String string, int i) throws SQLException {
        return this.ps.execute(string, i);
    }

    public boolean execute(String string, int[] ints) throws SQLException {
        return this.ps.execute(string, ints);
    }

    public boolean execute(String string, String[] strings) throws SQLException {
        return this.ps.execute(string, strings);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }
}

