/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc.spy;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.jdbc.spy.SpyCallableStatement;
import org.ofbiz.minerva.pool.jdbc.spy.SpyPreparedStatement;
import org.ofbiz.minerva.pool.jdbc.spy.SpyStatement;
import org.ofbiz.minerva.pool.jdbc.xa.XAConnectionFactory;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyConnection
implements Connection {
    private Logger log = Logger.getLogger(SpyConnection.class);
    private Connection c;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyConnection(XAConnectionFactory factory, XAConnection xaCon, Connection c) {
        this.c = c;
        XAConnectionMonitor mon = new XAConnectionMonitor(factory.getTransactionManager(), xaCon);
        try {
            mon.enlist();
        }
        catch (XAException e) {
            this.log.warn((Object)e);
        }
        finally {
            this.log.debug((Object)"SpyConnection instance; building connection monitor");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new SpyStatement(this, this.c.createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string), string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return new SpyCallableStatement(this, this.c.prepareCall(string), string);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.c.nativeSQL(string);
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.c.setAutoCommit(b);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.c.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.log.debug((Object)"connection commit()");
        this.c.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.log.debug((Object)"connection rollback()");
        this.c.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.log.debug((Object)"connection close()");
        this.c.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.c.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.c.getMetaData();
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        this.c.setReadOnly(b);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.c.isReadOnly();
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.c.setCatalog(string);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.c.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
        this.log.debug((Object)("setting connection isolation level to : " + i));
        this.c.setTransactionIsolation(i);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.c.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.c.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.c.clearWarnings();
    }

    @Override
    public Statement createStatement(int i, int i1) throws SQLException {
        return new SpyStatement(this, this.c.createStatement(i, i1));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int i, int i1) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string, i, i1), string);
    }

    @Override
    public CallableStatement prepareCall(String string, int i, int i1) throws SQLException {
        return new SpyCallableStatement(this, this.c.prepareCall(string, i, i1), string);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.c.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.c.setTypeMap(map);
    }

    @Override
    public void setHoldability(int i) throws SQLException {
        this.c.setHoldability(i);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.c.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.c.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.c.setSavepoint(string);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.log.debug((Object)"conection rollback(savepoint)");
        this.c.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.c.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int i, int i1, int i2) throws SQLException {
        return new SpyStatement(this, this.c.createStatement(i, i1, i2));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int i, int i1, int i2) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string, i, i1, i2), string);
    }

    @Override
    public CallableStatement prepareCall(String string, int i, int i1, int i2) throws SQLException {
        return new SpyCallableStatement(this, this.c.prepareCall(string, i, i1, i2), string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int i) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string, i), string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] ints) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string, ints), string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] strings) throws SQLException {
        return new SpyPreparedStatement(this, this.c.prepareStatement(string, strings), string);
    }
}

