/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.ofbiz.minerva.pool.jdbc.ConnectionWrapper;
import org.ofbiz.minerva.pool.jdbc.ResultSetInPool;
import org.ofbiz.minerva.pool.jdbc.StatementInPool;

public class PreparedStatementInPool
extends StatementInPool
implements PreparedStatement {
    private static final String CLOSED = "PreparedStatement has been closed!";
    private PreparedStatement impl;
    private ConnectionWrapper con;
    private String sql;

    public PreparedStatementInPool(PreparedStatement source, ConnectionWrapper owner, String sql) {
        super(source, owner);
        if (source == null || owner == null) {
            throw new NullPointerException();
        }
        this.impl = source;
        this.con = owner;
        this.sql = sql;
    }

    public PreparedStatement getUnderlyingPreparedStatement() {
        return this.impl;
    }

    public String getSql() {
        return this.sql;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return new ResultSetInPool(this.impl.executeQuery(), this);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int executeUpdate() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return this.impl.executeUpdate();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void clearParameters() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.clearParameters();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean execute() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return this.impl.execute();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void addBatch() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.addBatch();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setRef(i, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setBlob(i, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setClob(i, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setArray(i, x);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getMetaData();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        if (this.con != null) {
            this.con.statementClosed(this);
        }
        super.clearFields();
        this.con = null;
        this.impl = null;
        this.sql = null;
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }
}

