/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.ofbiz.base.util.Log4jLoggerWriter;
import org.ofbiz.minerva.pool.ObjectPool;
import org.ofbiz.minerva.pool.jdbc.JDBCConnectionFactory;
import org.ofbiz.minerva.pool.jdbc.PoolDriver;

public class JDBCPoolDataSource
implements DataSource,
Referenceable,
ObjectFactory {
    private static Logger log = Logger.getLogger(JDBCPoolDataSource.class);
    private static HashMap sources = new HashMap();
    private ObjectPool pool = new ObjectPool();
    private JDBCConnectionFactory factory = new JDBCConnectionFactory();
    private PrintWriter logWriter;
    private int timeout;
    private boolean initialized = false;
    private String jndiName;

    public static Collection getDataSources() {
        return new HashSet(sources.values());
    }

    public static JDBCPoolDataSource getDataSource(String poolName) {
        return (JDBCPoolDataSource)sources.get(poolName);
    }

    public JDBCPoolDataSource() {
        PoolDriver.instance();
    }

    public void setJNDIName(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        if (this.jndiName != null && !this.jndiName.equals(name)) {
            ctx.unbind(this.jndiName);
        }
        if (name != null) {
            ctx.bind(name, (Object)this);
        }
        this.jndiName = name;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJDBCURL(String url) {
        this.factory.setConnectURL(url);
    }

    public String getJDBCURL() {
        return this.factory.getConnectURL();
    }

    public void setJDBCProperties(Properties props) {
        this.factory.setConnectProperties(props);
    }

    public void setProperties(String props) {
        this.setJDBCProperties(JDBCPoolDataSource.parseProperties(props));
    }

    public Properties getJDBCProperties() {
        return this.factory.getConnectProperties();
    }

    public void setJDBCUser(String user) {
        this.factory.setUser(user);
    }

    public String getJDBCUser() {
        return this.factory.getUser();
    }

    public void setJDBCPassword(String password) {
        this.factory.setPassword(password);
    }

    public String getJDBCPassword() {
        return this.factory.getPassword();
    }

    public void setPoolName(String name) {
        this.pool.setName(name);
        sources.put(this.pool.getName(), this);
    }

    public String getPoolName() {
        return this.pool.getName();
    }

    public void setMinSize(int size) {
        this.pool.setMinSize(size);
    }

    public int getMinSize() {
        return this.pool.getMinSize();
    }

    public void setMaxSize(int size) {
        this.pool.setMaxSize(size);
    }

    public int getMaxSize() {
        return this.pool.getMaxSize();
    }

    public void setBlocking(boolean blocking) {
        this.pool.setBlocking(blocking);
    }

    public boolean isBlocking() {
        return this.pool.isBlocking();
    }

    public void setIdleTimeoutEnabled(boolean allowShrinking) {
        this.pool.setIdleTimeoutEnabled(allowShrinking);
    }

    public boolean isIdleTimeoutEnabled() {
        return this.pool.isIdleTimeoutEnabled();
    }

    public void setGCEnabled(boolean allowGC) {
        this.pool.setGCEnabled(allowGC);
    }

    public boolean isGCEnabled() {
        return this.pool.isGCEnabled();
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        this.pool.setMaxIdleTimeoutPercent(percent);
    }

    public float getMaxIdleTimeoutPercent() {
        return this.pool.getMaxIdleTimeoutPercent();
    }

    public void setIdleTimeout(long millis) {
        this.pool.setIdleTimeout(millis);
    }

    public long getIdleTimeout() {
        return this.pool.getIdleTimeout();
    }

    public void setGCMinIdleTime(long millis) {
        this.pool.setGCMinIdleTime(millis);
    }

    public long getGCMinIdleTime() {
        return this.pool.getGCMinIdleTime();
    }

    public void setGCInterval(long millis) {
        this.pool.setGCInterval(millis);
    }

    public long getGCInterval() {
        return this.pool.getGCInterval();
    }

    public void setInvalidateOnError(boolean invalidate) {
        this.pool.setInvalidateOnError(invalidate);
    }

    public boolean isInvalidateOnError() {
        return this.pool.isInvalidateOnError();
    }

    public void setTimestampUsed(boolean timestamp) {
        this.pool.setTimestampUsed(timestamp);
    }

    public boolean isTimestampUsed() {
        return this.pool.isTimestampUsed();
    }

    public void initialize() {
        this.initialized = true;
        this.pool.setObjectFactory(this.factory);
        this.pool.initialize();
    }

    public String getPoolStatus() {
        return this.pool.toString();
    }

    public void close() {
        try {
            this.setJNDIName(null);
        }
        catch (NamingException e) {
            log.warn((Object)"Can't unbind from JNDI", (Throwable)e);
        }
        sources.remove(this.pool.getName());
        this.pool.shutDown();
        this.pool = null;
        this.factory = null;
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        return (Connection)this.pool.getObject();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        this.factory.setUser(user);
        this.factory.setPassword(password);
        return (Connection)this.pool.getObject();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (writer == null) {
            this.logWriter = null;
        } else if (this.logWriter == null) {
            this.logWriter = new Log4jLoggerWriter(log);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.timeout = timeout;
    }

    private static Properties parseProperties(String string) {
        Properties props = new Properties();
        if (string == null || string.length() == 0) {
            return props;
        }
        int lastPos = -1;
        int pos = string.indexOf(";");
        while (pos > -1) {
            JDBCPoolDataSource.addProperty(props, string.substring(lastPos + 1, pos));
            lastPos = pos;
            pos = string.indexOf(";", lastPos + 1);
        }
        JDBCPoolDataSource.addProperty(props, string.substring(lastPos + 1));
        return props;
    }

    private static void addProperty(Properties props, String property) {
        int pos = property.indexOf("=");
        if (pos < 0) {
            System.err.println("Unable to parse property '" + property + "' - please use 'name=value'");
            return;
        }
        props.setProperty(property.substring(0, pos), property.substring(pos + 1));
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName(), new StringRefAddr("JDBCPool", this.pool.getName()), this.getClass().getName(), null);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        Reference ref;
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(this.getClass().getName())) {
            RefAddr addr = ref.get("JDBCPool");
            return sources.get(addr.getContent());
        }
        return null;
    }
}

