/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.ObjectPool;
import org.ofbiz.minerva.pool.PoolObjectFactory;
import org.ofbiz.minerva.pool.cache.ObjectCache;
import org.ofbiz.minerva.pool.jdbc.ConnectionInPool;

public class JDBCConnectionFactory
extends PoolObjectFactory {
    private String url;
    private Properties props;
    private String userName;
    private String password;
    private int psCacheSize = 10;
    private ObjectPool pool;
    private static Logger log = Logger.getLogger(JDBCConnectionFactory.class);

    public void setConnectURL(String url) {
        this.url = url;
    }

    public String getConnectURL() {
        return this.url;
    }

    public void setConnectProperties(Properties props) {
        this.props = props;
    }

    public Properties getConnectProperties() {
        return this.props;
    }

    public void setUser(String userName) {
        this.userName = userName;
    }

    public String getUser() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPSCacheSize(int size) {
        this.psCacheSize = size;
    }

    public int getPSCacheSize() {
        return this.psCacheSize;
    }

    public void poolStarted(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting");
        }
        super.poolStarted(pool);
        if (this.url == null) {
            log.error((Object)"Must specify JDBC connection URL");
            throw new IllegalStateException("Must specify JDBC connection URL to " + this.getClass().getName());
        }
        this.pool = pool;
    }

    public void poolClosing(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        super.poolClosing(pool);
        this.pool = null;
    }

    public Object createObject(Object parameters) throws Exception {
        log.debug((Object)"Opening new connection");
        try {
            if (this.userName != null && this.userName.length() > 0) {
                return DriverManager.getConnection(this.url, this.userName, this.password);
            }
            if (this.props != null) {
                return DriverManager.getConnection(this.url, this.props);
            }
            return DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            log.error((Object)"SQL Error", (Throwable)e);
            throw e;
        }
    }

    public Object prepareObject(Object pooledObject) {
        Connection con = (Connection)pooledObject;
        ConnectionInPool wrapper = new ConnectionInPool(con);
        wrapper.setPSCacheSize(this.psCacheSize);
        return wrapper;
    }

    public Object translateObject(Object clientObject) {
        return ((ConnectionInPool)clientObject).getUnderlyingConnection();
    }

    public Object returnObject(Object clientObject) {
        ConnectionInPool wrapper = (ConnectionInPool)clientObject;
        Connection con = wrapper.getUnderlyingConnection();
        try {
            wrapper.reset();
        }
        catch (SQLException e) {
            this.pool.markObjectAsInvalid(clientObject);
        }
        return con;
    }

    public void deleteObject(Object pooledObject) {
        Connection con = (Connection)pooledObject;
        try {
            con.rollback();
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        ObjectCache cache = (ObjectCache)ConnectionInPool.psCaches.remove(con);
        if (cache != null) {
            cache.close();
        }
        try {
            con.close();
        }
        catch (SQLException ignored) {
            // empty catch block
        }
    }
}

