/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool.cache;

import java.io.PrintWriter;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.cache.CachedObjectFactory;
import org.ofbiz.minerva.pool.cache.ObjectCache;

public class LeastRecentlyUsedCache
implements ObjectCache {
    private final Object lock = new Object();
    private HashMap keyMap = new HashMap();
    private PrintWriter writer = null;
    private Node mostRecentNode;
    private Node leastRecentNode;
    private int size;
    private int maxSize;
    private CachedObjectFactory factory;
    private static Logger log = Logger.getLogger(LeastRecentlyUsedCache.class);

    public LeastRecentlyUsedCache(CachedObjectFactory factory, int maxSize) {
        this.factory = factory;
        this.maxSize = maxSize;
    }

    public Object getObject(Object key) {
        return this.getObject(key, false);
    }

    public Object useObject(Object key) {
        return this.getObject(key, true);
    }

    public void returnObject(Object key, Object value) {
        Object pooled = this.keyMap.get(key);
        Object source = this.factory.translateObject(value);
        if (pooled == null) {
            this.factory.deleteObject(source);
        } else if (pooled instanceof Node) {
            Node node = (Node)pooled;
            if (node.data == source) {
                try {
                    node.setUsed(false);
                }
                catch (ConcurrentModificationException e) {
                    log.trace((Object)"caught exception", (Throwable)e);
                }
            } else {
                this.factory.deleteObject(source);
            }
        } else if (pooled instanceof LinkedList) {
            for (Node node : (LinkedList)pooled) {
                if (node.data != source) continue;
                try {
                    node.setUsed(false);
                }
                catch (ConcurrentModificationException e) {
                    log.trace((Object)"caught exception", (Throwable)e);
                }
                return;
            }
            this.factory.deleteObject(source);
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + pooled.getClass().getName() + "' in keyMap!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjects(Object key) {
        Object object = this.lock;
        synchronized (object) {
            Object value = this.keyMap.get(key);
            if (value != null) {
                if (value instanceof Node) {
                    this.removeNode((Node)value);
                } else if (value instanceof LinkedList) {
                    LinkedList list = (LinkedList)value;
                    int max = list.size();
                    for (int i = 0; i < max; ++i) {
                        this.removeNode((Node)list.get(0));
                    }
                }
            }
        }
    }

    public void setSize(int maxSize) {
        this.maxSize = maxSize;
        this.checkMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            Node next;
            Node current = this.leastRecentNode;
            Node node = next = current == null ? null : current.moreRecent;
            while (current != null) {
                this.removeNode(current);
                current = next;
                next = current == null ? null : current.moreRecent;
            }
        }
    }

    private Object getObject(Object key, boolean use) {
        Node node2 = null;
        try {
            Object value = this.keyMap.get(key);
            if (value == null) {
                node2 = this.addObject(key);
            } else if (value instanceof Node) {
                node2 = (Node)value;
                if (!node2.used) {
                    this.makeMostRecent(node2);
                } else {
                    node2 = this.addObject(key);
                }
            } else if (value instanceof LinkedList) {
                for (Node node2 : (LinkedList)value) {
                    if (!node2.used) {
                        this.makeMostRecent(node2);
                        break;
                    }
                    node2 = null;
                }
                if (node2 == null) {
                    node2 = this.addObject(key);
                }
            } else {
                throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
            }
            if (use) {
                node2.setUsed(true);
            }
        }
        catch (ConcurrentModificationException e) {
            return this.getObject(key, use);
        }
        return this.factory.prepareObject(node2.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node addObject(Object key) {
        Node result;
        Object data;
        try {
            data = this.factory.createObject(key);
        }
        catch (Exception e) {
            log.error((Object)"error creating object", (Throwable)e);
            if (this.writer != null) {
                e.printStackTrace(this.writer);
            }
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mostRecentNode == null) {
                this.mostRecentNode = result = new Node(null, null, data);
                this.leastRecentNode = result;
            } else {
                this.mostRecentNode.moreRecent = result = new Node(this.mostRecentNode, null, data);
                this.mostRecentNode = result;
            }
            ++this.size;
            this.checkMaxSize();
        }
        Object value = this.keyMap.get(key);
        if (value == null) {
            this.keyMap.put(key, result);
        } else if (value instanceof LinkedList) {
            ((LinkedList)value).add(result);
        } else if (value instanceof Node) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(value);
            list.add(result);
            this.keyMap.put(key, list);
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
        }
        this.keyMap.put(result, key);
        return result;
    }

    private void checkMaxSize() {
        if (this.maxSize <= 0) {
            return;
        }
        while (this.size > this.maxSize) {
            Node drop = this.leastRecentNode;
            this.leastRecentNode = drop.moreRecent;
            this.leastRecentNode.lessRecent = null;
            --this.size;
            this.removeNode(drop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeMostRecent(Node node) {
        Object object = this.lock;
        synchronized (object) {
            Node next;
            if (node.moreRecent == null) {
                if (this.mostRecentNode != node) {
                    throw new ConcurrentModificationException();
                }
                return;
            }
            Node previous = node.moreRecent;
            previous.lessRecent = next = node.lessRecent;
            if (next == null) {
                this.leastRecentNode = previous;
            } else {
                next.moreRecent = previous;
            }
            node.moreRecent = null;
            node.lessRecent = this.mostRecentNode;
            this.mostRecentNode.moreRecent = node;
            this.mostRecentNode = node;
        }
    }

    private void removeNode(Node node) {
        Object key;
        Object value;
        boolean used = node.used;
        if (!used) {
            node.used = true;
        }
        if ((value = this.keyMap.get(key = this.keyMap.remove(node))) instanceof Node) {
            this.keyMap.remove(key);
        } else if (value instanceof LinkedList) {
            LinkedList list = (LinkedList)value;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Node current = (Node)it.next();
                if (current != node) continue;
                it.remove();
                break;
            }
            if (list.size() == 1) {
                this.keyMap.put(key, list.get(0));
            }
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
        }
        if (!used) {
            this.factory.deleteObject(node.data);
        }
        node.moreRecent = null;
        node.lessRecent = null;
    }

    private class Node {
        Node lessRecent;
        Node moreRecent;
        Object data;
        boolean used = false;

        public Node(Node lessRecent, Node moreRecent, Object data) {
            this(lessRecent, moreRecent, data, false);
        }

        public Node(Node lessRecent, Node moreRecent, Object data, boolean used) {
            this.lessRecent = lessRecent;
            this.moreRecent = moreRecent;
            this.data = data;
            this.used = used;
        }

        public synchronized void setUsed(boolean used) {
            if (this.used == used) {
                throw new ConcurrentModificationException();
            }
            this.used = used;
        }
    }
}

