/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.ObjectPool;

class PoolGCThread
extends Thread {
    private HashSet pools = new HashSet();
    private static Logger log = Logger.getLogger(ObjectPool.class);

    PoolGCThread() {
        super("Minerva ObjectPool GC Thread");
        this.setDaemon(true);
    }

    public void run() {
        boolean trace = log.isDebugEnabled();
        while (true) {
            this.waitForPools();
            if (trace) {
                log.debug((Object)"gc thread waited for pools");
            }
            long delay = this.getDelay();
            if (trace) {
                log.debug((Object)("gc thread delay: " + delay));
            }
            if (delay > 0L) {
                try {
                    PoolGCThread.sleep(delay);
                }
                catch (InterruptedException ignored) {
                    log.trace((Object)ignored);
                }
            }
            this.runGC();
        }
    }

    private synchronized void waitForPools() {
        while (this.pools.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ignored) {
                log.warn((Object)"waitForPools interrupted");
            }
        }
    }

    private synchronized long getDelay() {
        long next = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        for (ObjectPool pool : this.pools) {
            long current = pool.getNextGCMillis(now);
            if (current >= next) continue;
            next = current;
        }
        return next >= 0L ? next : 0L;
    }

    private synchronized void runGC() {
        boolean trace = log.isDebugEnabled();
        if (trace) {
            log.debug((Object)"GC thread running GC");
        }
        for (ObjectPool pool : this.pools) {
            if (trace) {
                log.debug((Object)("GC Thread pool: " + pool.getName() + ", isTimeToGC(): " + pool.isTimeToGC()));
                log.debug((Object)pool.displayPoolData());
            }
            if (!pool.isTimeToGC()) continue;
            try {
                pool.runGCandShrink();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
    }

    synchronized void addPool(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding pool: " + pool.getName() + ", GC enabled: " + pool.isGCEnabled()));
        }
        if (pool.isGCEnabled()) {
            this.pools.add(pool);
        }
        this.notify();
    }

    synchronized void removePool(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing pool: " + pool.getName()));
        }
        this.pools.remove(pool);
    }

    public void finalize() throws Throwable {
        super.finalize();
        log.trace((Object)"GC thread finalize() called; ending");
    }
}

