/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool;

import java.util.ConcurrentModificationException;
import java.util.Date;
import javax.transaction.xa.Xid;
import org.ofbiz.minerva.pool.jdbc.xa.wrapper.XAConnectionExt;

public class ObjectRecord {
    private long created;
    private long lastUsed;
    private Thread thread;
    private Object object;
    private Object clientObject;
    private boolean inUse;

    public ObjectRecord(Object ob) {
        this(ob, true);
    }

    public ObjectRecord(Object ob, boolean inUse) {
        this.created = this.lastUsed = System.currentTimeMillis();
        this.object = ob;
        this.inUse = inUse;
        if (inUse) {
            this.thread = Thread.currentThread();
        }
    }

    public int getTransactionTimeout() {
        int timeout = -1;
        if (this.object instanceof XAConnectionExt) {
            try {
                timeout = ((XAConnectionExt)this.object).getXAResource().getTransactionTimeout();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return timeout;
    }

    public Xid getCurrentXid() {
        Xid xid = null;
        if (this.object instanceof XAConnectionExt) {
            try {
                xid = ((XAConnectionExt)this.object).getXAResourceImpl().getCurrent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return xid;
    }

    public Date getCreationDate() {
        return new Date(this.created);
    }

    public Date getLastUsedDate() {
        return new Date(this.lastUsed);
    }

    public long getMillisSinceLastUse() {
        return System.currentTimeMillis() - this.lastUsed;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public synchronized void setInUse(boolean inUse) throws ConcurrentModificationException {
        if (this.inUse == inUse) {
            throw new ConcurrentModificationException();
        }
        this.inUse = inUse;
        this.lastUsed = System.currentTimeMillis();
        if (!inUse) {
            this.clientObject = null;
            this.thread = null;
        } else {
            this.thread = Thread.currentThread();
        }
    }

    public void setLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public Object getObject() {
        return this.object;
    }

    public void setClientObject(Object o) {
        this.clientObject = o;
    }

    public Object getClientObject() {
        return this.clientObject == null ? this.object : this.clientObject;
    }

    public void close() {
        this.object = null;
        this.clientObject = null;
        this.lastUsed = Long.MAX_VALUE;
        this.created = Long.MAX_VALUE;
        this.inUse = true;
    }

    public Thread getThread() {
        return this.thread;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.object.toString());
        buf.append(" : created : [").append(this.getCreationDate().toString());
        buf.append("] : last used : [").append(this.getLastUsedDate().toString());
        buf.append("] : thread : [").append(this.thread != null ? this.thread.getName() : "");
        buf.append("] : in tx: [").append(this.getCurrentXid() != null);
        buf.append("] : in use : [").append(this.inUse);
        buf.append("]");
        return buf.toString();
    }
}

